/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ID and expiry time of the attachment set returned by the <a>AddAttachmentsToSet</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddAttachmentsToSetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AddAttachmentsToSetResponse.Builder, AddAttachmentsToSetResponse> {
    private final String attachmentSetId;

    private final String expiryTime;

    private AddAttachmentsToSetResponse(BuilderImpl builder) {
        this.attachmentSetId = builder.attachmentSetId;
        this.expiryTime = builder.expiryTime;
    }

    /**
     * <p>
     * The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is
     * created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified, the
     * attachments are added to the specified set, if it exists.
     * </p>
     * 
     * @return The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set
     *         is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was
     *         specified, the attachments are added to the specified set, if it exists.
     */
    public String attachmentSetId() {
        return attachmentSetId;
    }

    /**
     * <p>
     * The time and date when the attachment set expires.
     * </p>
     * 
     * @return The time and date when the attachment set expires.
     */
    public String expiryTime() {
        return expiryTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentSetId());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAttachmentsToSetResponse)) {
            return false;
        }
        AddAttachmentsToSetResponse other = (AddAttachmentsToSetResponse) obj;
        return Objects.equals(attachmentSetId(), other.attachmentSetId()) && Objects.equals(expiryTime(), other.expiryTime());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachmentSetId() != null) {
            sb.append("AttachmentSetId: ").append(attachmentSetId()).append(",");
        }
        if (expiryTime() != null) {
            sb.append("ExpiryTime: ").append(expiryTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentSetId":
            return Optional.of(clazz.cast(attachmentSetId()));
        case "expiryTime":
            return Optional.of(clazz.cast(expiryTime()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AddAttachmentsToSetResponse> {
        /**
         * <p>
         * The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is
         * created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified,
         * the attachments are added to the specified set, if it exists.
         * </p>
         * 
         * @param attachmentSetId
         *        The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment
         *        set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code>
         *        was specified, the attachments are added to the specified set, if it exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSetId(String attachmentSetId);

        /**
         * <p>
         * The time and date when the attachment set expires.
         * </p>
         * 
         * @param expiryTime
         *        The time and date when the attachment set expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTime(String expiryTime);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentSetId;

        private String expiryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AddAttachmentsToSetResponse model) {
            attachmentSetId(model.attachmentSetId);
            expiryTime(model.expiryTime);
        }

        public final String getAttachmentSetId() {
            return attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        public final String getExpiryTime() {
            return expiryTime;
        }

        @Override
        public final Builder expiryTime(String expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final void setExpiryTime(String expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public AddAttachmentsToSetResponse build() {
            return new AddAttachmentsToSetResponse(this);
        }
    }
}
