/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current refresh status of a Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RefreshTrustedAdvisorCheckResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RefreshTrustedAdvisorCheckResponse.Builder, RefreshTrustedAdvisorCheckResponse> {
    private final TrustedAdvisorCheckRefreshStatus status;

    private RefreshTrustedAdvisorCheckResponse(BuilderImpl builder) {
        this.status = builder.status;
    }

    /**
     * <p>
     * The current refresh status for a check, including the amount of time until the check is eligible for refresh.
     * </p>
     * 
     * @return The current refresh status for a check, including the amount of time until the check is eligible for
     *         refresh.
     */
    public TrustedAdvisorCheckRefreshStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshTrustedAdvisorCheckResponse)) {
            return false;
        }
        RefreshTrustedAdvisorCheckResponse other = (RefreshTrustedAdvisorCheckResponse) obj;
        return Objects.equals(status(), other.status());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.of(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RefreshTrustedAdvisorCheckResponse> {
        /**
         * <p>
         * The current refresh status for a check, including the amount of time until the check is eligible for refresh.
         * </p>
         * 
         * @param status
         *        The current refresh status for a check, including the amount of time until the check is eligible for
         *        refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(TrustedAdvisorCheckRefreshStatus status);

        /**
         * <p>
         * The current refresh status for a check, including the amount of time until the check is eligible for refresh.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedAdvisorCheckRefreshStatus.Builder}
         * avoiding the need to create one manually via {@link TrustedAdvisorCheckRefreshStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedAdvisorCheckRefreshStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(TrustedAdvisorCheckRefreshStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link TrustedAdvisorCheckRefreshStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(TrustedAdvisorCheckRefreshStatus)
         */
        default Builder status(Consumer<TrustedAdvisorCheckRefreshStatus.Builder> status) {
            return status(TrustedAdvisorCheckRefreshStatus.builder().apply(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TrustedAdvisorCheckRefreshStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshTrustedAdvisorCheckResponse model) {
            status(model.status);
        }

        public final TrustedAdvisorCheckRefreshStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(TrustedAdvisorCheckRefreshStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(TrustedAdvisorCheckRefreshStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public RefreshTrustedAdvisorCheckResponse build() {
            return new RefreshTrustedAdvisorCheckResponse(this);
        }
    }
}
