/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.support.model.CaseDetails;
import software.amazon.awssdk.services.support.model.CaseListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCasesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCasesResponse> {
    private final List<CaseDetails> cases;
    private final String nextToken;

    private DescribeCasesResponse(BuilderImpl builder) {
        this.cases = builder.cases;
        this.nextToken = builder.nextToken;
    }

    public List<CaseDetails> cases() {
        return this.cases;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cases());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCasesResponse)) {
            return false;
        }
        DescribeCasesResponse other = (DescribeCasesResponse)((Object)obj);
        return Objects.equals(this.cases(), other.cases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cases() != null) {
            sb.append("Cases: ").append(this.cases()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cases": {
                return Optional.of(clazz.cast(this.cases()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<CaseDetails> cases;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCasesResponse model) {
            this.cases(model.cases);
            this.nextToken(model.nextToken);
        }

        public final Collection<CaseDetails.Builder> getCases() {
            return this.cases != null ? (Collection)this.cases.stream().map(CaseDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cases(Collection<CaseDetails> cases) {
            this.cases = CaseListCopier.copy(cases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(CaseDetails ... cases) {
            this.cases(Arrays.asList(cases));
            return this;
        }

        public final void setCases(Collection<CaseDetails.BuilderImpl> cases) {
            this.cases = CaseListCopier.copyFromBuilder(cases);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeCasesResponse build() {
            return new DescribeCasesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCasesResponse> {
        public Builder cases(Collection<CaseDetails> var1);

        public Builder cases(CaseDetails ... var1);

        public Builder nextToken(String var1);
    }
}

