/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.CaseDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON-formatted object that contains the metadata for a support case. It is contained the response from a
 * <a>DescribeCases</a> request. <b>CaseDetails</b> contains the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>caseId.</b> The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
 * formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>categoryCode.</b> The category of problem for the AWS Support case. Corresponds to the CategoryCode values
 * returned by a call to <a>DescribeServices</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>displayId.</b> The identifier for the case on pages in the AWS Support Center.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>language.</b> The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
 * English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>recentCommunications.</b> One or more <a>Communication</a> objects. Fields of these objects are
 * <code>attachments</code>, <code>body</code>, <code>caseId</code>, <code>submittedBy</code>, and
 * <code>timeCreated</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>nextToken.</b> A resumption point for pagination.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>serviceCode.</b> The identifier for the AWS service that corresponds to the service code defined in the call to
 * <a>DescribeServices</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>severityCode. </b>The severity code assigned to the case. Contains one of the values returned by the call to
 * <a>DescribeSeverityLevels</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>status.</b> The status of the case in the AWS Support Center.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>subject.</b> The subject line of the case.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>submittedBy.</b> The email address of the account that submitted the case.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>timeCreated.</b> The time the case was created, in ISO-8601 format.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class CaseDetails implements StructuredPojo, ToCopyableBuilder<CaseDetails.Builder, CaseDetails> {
    private final String caseId;

    private final String displayId;

    private final String subject;

    private final String status;

    private final String serviceCode;

    private final String categoryCode;

    private final String severityCode;

    private final String submittedBy;

    private final String timeCreated;

    private final RecentCaseCommunications recentCommunications;

    private final List<String> ccEmailAddresses;

    private final String language;

    private CaseDetails(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.displayId = builder.displayId;
        this.subject = builder.subject;
        this.status = builder.status;
        this.serviceCode = builder.serviceCode;
        this.categoryCode = builder.categoryCode;
        this.severityCode = builder.severityCode;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.recentCommunications = builder.recentCommunications;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
    }

    /**
     * <p>
     * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
     * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     * </p>
     * 
     * @return The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
     *         formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     */
    public String caseId() {
        return caseId;
    }

    /**
     * <p>
     * The ID displayed for the case in the AWS Support Center. This is a numeric string.
     * </p>
     * 
     * @return The ID displayed for the case in the AWS Support Center. This is a numeric string.
     */
    public String displayId() {
        return displayId;
    }

    /**
     * <p>
     * The subject line for the case in the AWS Support Center.
     * </p>
     * 
     * @return The subject line for the case in the AWS Support Center.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * The status of the case.
     * </p>
     * 
     * @return The status of the case.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The code for the AWS service returned by the call to <a>DescribeServices</a>.
     * </p>
     * 
     * @return The code for the AWS service returned by the call to <a>DescribeServices</a>.
     */
    public String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The category of problem for the AWS Support case.
     * </p>
     * 
     * @return The category of problem for the AWS Support case.
     */
    public String categoryCode() {
        return categoryCode;
    }

    /**
     * <p>
     * The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
     * </p>
     * 
     * @return The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
     */
    public String severityCode() {
        return severityCode;
    }

    /**
     * <p>
     * The email address of the account that submitted the case.
     * </p>
     * 
     * @return The email address of the account that submitted the case.
     */
    public String submittedBy() {
        return submittedBy;
    }

    /**
     * <p>
     * The time that the case was case created in the AWS Support Center.
     * </p>
     * 
     * @return The time that the case was case created in the AWS Support Center.
     */
    public String timeCreated() {
        return timeCreated;
    }

    /**
     * <p>
     * The five most recent communications between you and AWS Support Center, including the IDs of any attachments to
     * the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier communications.
     * </p>
     * 
     * @return The five most recent communications between you and AWS Support Center, including the IDs of any
     *         attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve
     *         earlier communications.
     */
    public RecentCaseCommunications recentCommunications() {
        return recentCommunications;
    }

    /**
     * <p>
     * The email addresses that receive copies of communication about the case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The email addresses that receive copies of communication about the case.
     */
    public List<String> ccEmailAddresses() {
        return ccEmailAddresses;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(displayId());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(categoryCode());
        hashCode = 31 * hashCode + Objects.hashCode(severityCode());
        hashCode = 31 * hashCode + Objects.hashCode(submittedBy());
        hashCode = 31 * hashCode + Objects.hashCode(timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(recentCommunications());
        hashCode = 31 * hashCode + Objects.hashCode(ccEmailAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseDetails)) {
            return false;
        }
        CaseDetails other = (CaseDetails) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(displayId(), other.displayId())
                && Objects.equals(subject(), other.subject()) && Objects.equals(status(), other.status())
                && Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(categoryCode(), other.categoryCode())
                && Objects.equals(severityCode(), other.severityCode()) && Objects.equals(submittedBy(), other.submittedBy())
                && Objects.equals(timeCreated(), other.timeCreated())
                && Objects.equals(recentCommunications(), other.recentCommunications())
                && Objects.equals(ccEmailAddresses(), other.ccEmailAddresses()) && Objects.equals(language(), other.language());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (caseId() != null) {
            sb.append("CaseId: ").append(caseId()).append(",");
        }
        if (displayId() != null) {
            sb.append("DisplayId: ").append(displayId()).append(",");
        }
        if (subject() != null) {
            sb.append("Subject: ").append(subject()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (serviceCode() != null) {
            sb.append("ServiceCode: ").append(serviceCode()).append(",");
        }
        if (categoryCode() != null) {
            sb.append("CategoryCode: ").append(categoryCode()).append(",");
        }
        if (severityCode() != null) {
            sb.append("SeverityCode: ").append(severityCode()).append(",");
        }
        if (submittedBy() != null) {
            sb.append("SubmittedBy: ").append(submittedBy()).append(",");
        }
        if (timeCreated() != null) {
            sb.append("TimeCreated: ").append(timeCreated()).append(",");
        }
        if (recentCommunications() != null) {
            sb.append("RecentCommunications: ").append(recentCommunications()).append(",");
        }
        if (ccEmailAddresses() != null) {
            sb.append("CcEmailAddresses: ").append(ccEmailAddresses()).append(",");
        }
        if (language() != null) {
            sb.append("Language: ").append(language()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.of(clazz.cast(caseId()));
        case "displayId":
            return Optional.of(clazz.cast(displayId()));
        case "subject":
            return Optional.of(clazz.cast(subject()));
        case "status":
            return Optional.of(clazz.cast(status()));
        case "serviceCode":
            return Optional.of(clazz.cast(serviceCode()));
        case "categoryCode":
            return Optional.of(clazz.cast(categoryCode()));
        case "severityCode":
            return Optional.of(clazz.cast(severityCode()));
        case "submittedBy":
            return Optional.of(clazz.cast(submittedBy()));
        case "timeCreated":
            return Optional.of(clazz.cast(timeCreated()));
        case "recentCommunications":
            return Optional.of(clazz.cast(recentCommunications()));
        case "ccEmailAddresses":
            return Optional.of(clazz.cast(ccEmailAddresses()));
        case "language":
            return Optional.of(clazz.cast(language()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CaseDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CaseDetails> {
        /**
         * <p>
         * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
         * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * </p>
         * 
         * @param caseId
         *        The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
         *        formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * The ID displayed for the case in the AWS Support Center. This is a numeric string.
         * </p>
         * 
         * @param displayId
         *        The ID displayed for the case in the AWS Support Center. This is a numeric string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayId(String displayId);

        /**
         * <p>
         * The subject line for the case in the AWS Support Center.
         * </p>
         * 
         * @param subject
         *        The subject line for the case in the AWS Support Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The status of the case.
         * </p>
         * 
         * @param status
         *        The status of the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The code for the AWS service returned by the call to <a>DescribeServices</a>.
         * </p>
         * 
         * @param serviceCode
         *        The code for the AWS service returned by the call to <a>DescribeServices</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The category of problem for the AWS Support case.
         * </p>
         * 
         * @param categoryCode
         *        The category of problem for the AWS Support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryCode(String categoryCode);

        /**
         * <p>
         * The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
         * </p>
         * 
         * @param severityCode
         *        The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCode(String severityCode);

        /**
         * <p>
         * The email address of the account that submitted the case.
         * </p>
         * 
         * @param submittedBy
         *        The email address of the account that submitted the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedBy(String submittedBy);

        /**
         * <p>
         * The time that the case was case created in the AWS Support Center.
         * </p>
         * 
         * @param timeCreated
         *        The time that the case was case created in the AWS Support Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCreated(String timeCreated);

        /**
         * <p>
         * The five most recent communications between you and AWS Support Center, including the IDs of any attachments
         * to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier
         * communications.
         * </p>
         * 
         * @param recentCommunications
         *        The five most recent communications between you and AWS Support Center, including the IDs of any
         *        attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve
         *        earlier communications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recentCommunications(RecentCaseCommunications recentCommunications);

        /**
         * <p>
         * The five most recent communications between you and AWS Support Center, including the IDs of any attachments
         * to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier
         * communications.
         * </p>
         * This is a convenience that creates an instance of the {@link RecentCaseCommunications.Builder} avoiding the
         * need to create one manually via {@link RecentCaseCommunications#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecentCaseCommunications.Builder#build()} is called immediately
         * and its result is passed to {@link #recentCommunications(RecentCaseCommunications)}.
         * 
         * @param recentCommunications
         *        a consumer that will call methods on {@link RecentCaseCommunications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recentCommunications(RecentCaseCommunications)
         */
        default Builder recentCommunications(Consumer<RecentCaseCommunications.Builder> recentCommunications) {
            return recentCommunications(RecentCaseCommunications.builder().apply(recentCommunications).build());
        }

        /**
         * <p>
         * The email addresses that receive copies of communication about the case.
         * </p>
         * 
         * @param ccEmailAddresses
         *        The email addresses that receive copies of communication about the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(Collection<String> ccEmailAddresses);

        /**
         * <p>
         * The email addresses that receive copies of communication about the case.
         * </p>
         * 
         * @param ccEmailAddresses
         *        The email addresses that receive copies of communication about the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(String... ccEmailAddresses);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);
    }

    static final class BuilderImpl implements Builder {
        private String caseId;

        private String displayId;

        private String subject;

        private String status;

        private String serviceCode;

        private String categoryCode;

        private String severityCode;

        private String submittedBy;

        private String timeCreated;

        private RecentCaseCommunications recentCommunications;

        private List<String> ccEmailAddresses;

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseDetails model) {
            caseId(model.caseId);
            displayId(model.displayId);
            subject(model.subject);
            status(model.status);
            serviceCode(model.serviceCode);
            categoryCode(model.categoryCode);
            severityCode(model.severityCode);
            submittedBy(model.submittedBy);
            timeCreated(model.timeCreated);
            recentCommunications(model.recentCommunications);
            ccEmailAddresses(model.ccEmailAddresses);
            language(model.language);
        }

        public final String getCaseId() {
            return caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getDisplayId() {
            return displayId;
        }

        @Override
        public final Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final void setDisplayId(String displayId) {
            this.displayId = displayId;
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getCategoryCode() {
            return categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        public final String getSeverityCode() {
            return severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        public final String getSubmittedBy() {
            return submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        public final String getTimeCreated() {
            return timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final RecentCaseCommunications.Builder getRecentCommunications() {
            return recentCommunications != null ? recentCommunications.toBuilder() : null;
        }

        @Override
        public final Builder recentCommunications(RecentCaseCommunications recentCommunications) {
            this.recentCommunications = recentCommunications;
            return this;
        }

        public final void setRecentCommunications(RecentCaseCommunications.BuilderImpl recentCommunications) {
            this.recentCommunications = recentCommunications != null ? recentCommunications.build() : null;
        }

        public final Collection<String> getCcEmailAddresses() {
            return ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String... ccEmailAddresses) {
            ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public CaseDetails build() {
            return new CaseDetails(this);
        }
    }
}
