/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAttachmentRequest extends SupportRequest implements
        ToCopyableBuilder<DescribeAttachmentRequest.Builder, DescribeAttachmentRequest> {
    private final String attachmentId;

    private DescribeAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
    }

    /**
     * <p>
     * The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a> operation.
     * </p>
     * 
     * @return The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a>
     *         operation.
     */
    public String attachmentId() {
        return attachmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAttachmentRequest)) {
            return false;
        }
        DescribeAttachmentRequest other = (DescribeAttachmentRequest) obj;
        return Objects.equals(attachmentId(), other.attachmentId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachmentId() != null) {
            sb.append("AttachmentId: ").append(attachmentId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentId":
            return Optional.of(clazz.cast(attachmentId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportRequest.Builder, CopyableBuilder<Builder, DescribeAttachmentRequest> {
        /**
         * <p>
         * The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a>
         * operation.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private String attachmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAttachmentRequest model) {
            attachmentId(model.attachmentId);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeAttachmentRequest build() {
            return new DescribeAttachmentRequest(this);
        }
    }
}
