/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns an array of <a>CaseDetails</a> objects and a <code>nextToken</code> that defines a point for pagination in
 * the result set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCasesResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeCasesResponse.Builder, DescribeCasesResponse> {
    private final List<CaseDetails> cases;

    private final String nextToken;

    private DescribeCasesResponse(BuilderImpl builder) {
        super(builder);
        this.cases = builder.cases;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The details for the cases that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details for the cases that match the request.
     */
    public List<CaseDetails> cases() {
        return cases;
    }

    /**
     * <p>
     * A resumption point for pagination.
     * </p>
     * 
     * @return A resumption point for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cases());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCasesResponse)) {
            return false;
        }
        DescribeCasesResponse other = (DescribeCasesResponse) obj;
        return Objects.equals(cases(), other.cases()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cases() != null) {
            sb.append("Cases: ").append(cases()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cases":
            return Optional.of(clazz.cast(cases()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportResponse.Builder, CopyableBuilder<Builder, DescribeCasesResponse> {
        /**
         * <p>
         * The details for the cases that match the request.
         * </p>
         * 
         * @param cases
         *        The details for the cases that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cases(Collection<CaseDetails> cases);

        /**
         * <p>
         * The details for the cases that match the request.
         * </p>
         * 
         * @param cases
         *        The details for the cases that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cases(CaseDetails... cases);

        /**
         * <p>
         * A resumption point for pagination.
         * </p>
         * 
         * @param nextToken
         *        A resumption point for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<CaseDetails> cases;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCasesResponse model) {
            cases(model.cases);
            nextToken(model.nextToken);
        }

        public final Collection<CaseDetails.Builder> getCases() {
            return cases != null ? cases.stream().map(CaseDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cases(Collection<CaseDetails> cases) {
            this.cases = CaseListCopier.copy(cases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(CaseDetails... cases) {
            cases(Arrays.asList(cases));
            return this;
        }

        public final void setCases(Collection<CaseDetails.BuilderImpl> cases) {
            this.cases = CaseListCopier.copyFromBuilder(cases);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeCasesResponse build() {
            return new DescribeCasesResponse(this);
        }
    }
}
