/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The communications returned by the <a>DescribeCommunications</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCommunicationsResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeCommunicationsResponse.Builder, DescribeCommunicationsResponse> {
    private final List<Communication> communications;

    private final String nextToken;

    private DescribeCommunicationsResponse(BuilderImpl builder) {
        super(builder);
        this.communications = builder.communications;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The communications for the case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The communications for the case.
     */
    public List<Communication> communications() {
        return communications;
    }

    /**
     * <p>
     * A resumption point for pagination.
     * </p>
     * 
     * @return A resumption point for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(communications());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommunicationsResponse)) {
            return false;
        }
        DescribeCommunicationsResponse other = (DescribeCommunicationsResponse) obj;
        return Objects.equals(communications(), other.communications()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (communications() != null) {
            sb.append("Communications: ").append(communications()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "communications":
            return Optional.of(clazz.cast(communications()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportResponse.Builder, CopyableBuilder<Builder, DescribeCommunicationsResponse> {
        /**
         * <p>
         * The communications for the case.
         * </p>
         * 
         * @param communications
         *        The communications for the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communications(Collection<Communication> communications);

        /**
         * <p>
         * The communications for the case.
         * </p>
         * 
         * @param communications
         *        The communications for the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communications(Communication... communications);

        /**
         * <p>
         * A resumption point for pagination.
         * </p>
         * 
         * @param nextToken
         *        A resumption point for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<Communication> communications;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommunicationsResponse model) {
            communications(model.communications);
            nextToken(model.nextToken);
        }

        public final Collection<Communication.Builder> getCommunications() {
            return communications != null ? communications.stream().map(Communication::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder communications(Collection<Communication> communications) {
            this.communications = CommunicationListCopier.copy(communications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communications(Communication... communications) {
            communications(Arrays.asList(communications));
            return this;
        }

        public final void setCommunications(Collection<Communication.BuilderImpl> communications) {
            this.communications = CommunicationListCopier.copyFromBuilder(communications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeCommunicationsResponse build() {
            return new DescribeCommunicationsResponse(this);
        }
    }
}
