/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTrustedAdvisorCheckRefreshStatusesRequest extends SupportRequest
        implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckRefreshStatusesRequest.Builder, DescribeTrustedAdvisorCheckRefreshStatusesRequest> {
    private final List<String> checkIds;

    private DescribeTrustedAdvisorCheckRefreshStatusesRequest(BuilderImpl builder) {
        super(builder);
        this.checkIds = builder.checkIds;
    }

    /**
     * <p>
     * The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a check that
     * is automatically refreshed causes an <code>InvalidParameterValue</code> error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a
     *         check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
     */
    public List<String> checkIds() {
        return checkIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckRefreshStatusesRequest)) {
            return false;
        }
        DescribeTrustedAdvisorCheckRefreshStatusesRequest other = (DescribeTrustedAdvisorCheckRefreshStatusesRequest) obj;
        return Objects.equals(checkIds(), other.checkIds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (checkIds() != null) {
            sb.append("CheckIds: ").append(checkIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkIds":
            return Optional.of(clazz.cast(checkIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportRequest.Builder,
            CopyableBuilder<Builder, DescribeTrustedAdvisorCheckRefreshStatusesRequest> {
        /**
         * <p>
         * The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a check
         * that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param checkIds
         *        The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a
         *        check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIds(Collection<String> checkIds);

        /**
         * <p>
         * The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a check
         * that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param checkIds
         *        The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a
         *        check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIds(String... checkIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private List<String> checkIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckRefreshStatusesRequest model) {
            checkIds(model.checkIds);
        }

        public final Collection<String> getCheckIds() {
            return checkIds;
        }

        @Override
        public final Builder checkIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIds(String... checkIds) {
            checkIds(Arrays.asList(checkIds));
            return this;
        }

        public final void setCheckIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrustedAdvisorCheckRefreshStatusesRequest build() {
            return new DescribeTrustedAdvisorCheckRefreshStatusesRequest(this);
        }
    }
}
