/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckRefreshStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The refresh status of a Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrustedAdvisorCheckRefreshStatus implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCheckRefreshStatus.Builder, TrustedAdvisorCheckRefreshStatus> {
    private final String checkId;

    private final String status;

    private final Long millisUntilNextRefreshable;

    private TrustedAdvisorCheckRefreshStatus(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.status = builder.status;
        this.millisUntilNextRefreshable = builder.millisUntilNextRefreshable;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The status of the Trusted Advisor check for which a refresh has been requested: "none", "enqueued", "processing",
     * "success", or "abandoned".
     * </p>
     * 
     * @return The status of the Trusted Advisor check for which a refresh has been requested: "none", "enqueued",
     *         "processing", "success", or "abandoned".
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
     * </p>
     * 
     * @return The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
     */
    public Long millisUntilNextRefreshable() {
        return millisUntilNextRefreshable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(millisUntilNextRefreshable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckRefreshStatus)) {
            return false;
        }
        TrustedAdvisorCheckRefreshStatus other = (TrustedAdvisorCheckRefreshStatus) obj;
        return Objects.equals(checkId(), other.checkId()) && Objects.equals(status(), other.status())
                && Objects.equals(millisUntilNextRefreshable(), other.millisUntilNextRefreshable());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (checkId() != null) {
            sb.append("CheckId: ").append(checkId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (millisUntilNextRefreshable() != null) {
            sb.append("MillisUntilNextRefreshable: ").append(millisUntilNextRefreshable()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkId":
            return Optional.of(clazz.cast(checkId()));
        case "status":
            return Optional.of(clazz.cast(status()));
        case "millisUntilNextRefreshable":
            return Optional.of(clazz.cast(millisUntilNextRefreshable()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckRefreshStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCheckRefreshStatus> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The status of the Trusted Advisor check for which a refresh has been requested: "none", "enqueued",
         * "processing", "success", or "abandoned".
         * </p>
         * 
         * @param status
         *        The status of the Trusted Advisor check for which a refresh has been requested: "none", "enqueued",
         *        "processing", "success", or "abandoned".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
         * </p>
         * 
         * @param millisUntilNextRefreshable
         *        The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder millisUntilNextRefreshable(Long millisUntilNextRefreshable);
    }

    static final class BuilderImpl implements Builder {
        private String checkId;

        private String status;

        private Long millisUntilNextRefreshable;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckRefreshStatus model) {
            checkId(model.checkId);
            status(model.status);
            millisUntilNextRefreshable(model.millisUntilNextRefreshable);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getMillisUntilNextRefreshable() {
            return millisUntilNextRefreshable;
        }

        @Override
        public final Builder millisUntilNextRefreshable(Long millisUntilNextRefreshable) {
            this.millisUntilNextRefreshable = millisUntilNextRefreshable;
            return this;
        }

        public final void setMillisUntilNextRefreshable(Long millisUntilNextRefreshable) {
            this.millisUntilNextRefreshable = millisUntilNextRefreshable;
        }

        @Override
        public TrustedAdvisorCheckRefreshStatus build() {
            return new TrustedAdvisorCheckRefreshStatus(this);
        }
    }
}
