/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeServicesRequest extends SupportRequest implements
        ToCopyableBuilder<DescribeServicesRequest.Builder, DescribeServicesRequest> {
    private final List<String> serviceCodeList;

    private final String language;

    private DescribeServicesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCodeList = builder.serviceCodeList;
        this.language = builder.language;
    }

    /**
     * <p>
     * A JSON-formatted list of service codes available for AWS services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A JSON-formatted list of service codes available for AWS services.
     */
    public List<String> serviceCodeList() {
        return serviceCodeList;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCodeList());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesRequest)) {
            return false;
        }
        DescribeServicesRequest other = (DescribeServicesRequest) obj;
        return Objects.equals(serviceCodeList(), other.serviceCodeList()) && Objects.equals(language(), other.language());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeServicesRequest").add("ServiceCodeList", serviceCodeList()).add("Language", language())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceCodeList":
            return Optional.of(clazz.cast(serviceCodeList()));
        case "language":
            return Optional.of(clazz.cast(language()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportRequest.Builder, CopyableBuilder<Builder, DescribeServicesRequest> {
        /**
         * <p>
         * A JSON-formatted list of service codes available for AWS services.
         * </p>
         * 
         * @param serviceCodeList
         *        A JSON-formatted list of service codes available for AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodeList(Collection<String> serviceCodeList);

        /**
         * <p>
         * A JSON-formatted list of service codes available for AWS services.
         * </p>
         * 
         * @param serviceCodeList
         *        A JSON-formatted list of service codes available for AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodeList(String... serviceCodeList);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private List<String> serviceCodeList;

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesRequest model) {
            serviceCodeList(model.serviceCodeList);
            language(model.language);
        }

        public final Collection<String> getServiceCodeList() {
            return serviceCodeList;
        }

        @Override
        public final Builder serviceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodeList(String... serviceCodeList) {
            serviceCodeList(Arrays.asList(serviceCodeList));
            return this;
        }

        public final void setServiceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeServicesRequest build() {
            return new DescribeServicesRequest(this);
        }
    }
}
