/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.CaseDetails;

@SdkInternalApi
public class CaseDetailsMarshaller {
    private static final MarshallingInfo<String> CASEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caseId").build();
    private static final MarshallingInfo<String> DISPLAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayId").build();
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subject").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> SERVICECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceCode").build();
    private static final MarshallingInfo<String> CATEGORYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("categoryCode").build();
    private static final MarshallingInfo<String> SEVERITYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severityCode").build();
    private static final MarshallingInfo<String> SUBMITTEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("submittedBy").build();
    private static final MarshallingInfo<String> TIMECREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeCreated").build();
    private static final MarshallingInfo<StructuredPojo> RECENTCOMMUNICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recentCommunications").build();
    private static final MarshallingInfo<List> CCEMAILADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ccEmailAddresses").build();
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").build();
    private static final CaseDetailsMarshaller INSTANCE = new CaseDetailsMarshaller();

    public static CaseDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CaseDetails caseDetails, ProtocolMarshaller protocolMarshaller) {
        if (caseDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)caseDetails.caseId(), CASEID_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.displayId(), DISPLAYID_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.serviceCode(), SERVICECODE_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.categoryCode(), CATEGORYCODE_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.severityCode(), SEVERITYCODE_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.submittedBy(), SUBMITTEDBY_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.timeCreated(), TIMECREATED_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.recentCommunications(), RECENTCOMMUNICATIONS_BINDING);
            protocolMarshaller.marshall(caseDetails.ccEmailAddresses(), CCEMAILADDRESSES_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.language(), LANGUAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

