/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of AWS services returned by the <a>DescribeServices</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeServicesResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeServicesResponse.Builder, DescribeServicesResponse> {
    private final List<Service> services;

    private DescribeServicesResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
    }

    /**
     * <p>
     * A JSON-formatted list of AWS services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A JSON-formatted list of AWS services.
     */
    public List<Service> services() {
        return services;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(services());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesResponse)) {
            return false;
        }
        DescribeServicesResponse other = (DescribeServicesResponse) obj;
        return Objects.equals(services(), other.services());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeServicesResponse").add("Services", services()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "services":
            return Optional.of(clazz.cast(services()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportResponse.Builder, CopyableBuilder<Builder, DescribeServicesResponse> {
        /**
         * <p>
         * A JSON-formatted list of AWS services.
         * </p>
         * 
         * @param services
         *        A JSON-formatted list of AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<Service> services);

        /**
         * <p>
         * A JSON-formatted list of AWS services.
         * </p>
         * 
         * @param services
         *        A JSON-formatted list of AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Service... services);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<Service> services;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesResponse model) {
            services(model.services);
        }

        public final Collection<Service.Builder> getServices() {
            return services != null ? services.stream().map(Service::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service... services) {
            services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServiceListCopier.copyFromBuilder(services);
        }

        @Override
        public DescribeServicesResponse build() {
            return new DescribeServicesResponse(this);
        }
    }
}
