/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.CreateCaseRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateCaseRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateCaseRequestModelMarshaller {
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subject").isBinary(false).build();

    private static final MarshallingInfo<String> SERVICECODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceCode").isBinary(false).build();

    private static final MarshallingInfo<String> SEVERITYCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severityCode").isBinary(false).build();

    private static final MarshallingInfo<String> CATEGORYCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("categoryCode").isBinary(false).build();

    private static final MarshallingInfo<String> COMMUNICATIONBODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("communicationBody").isBinary(false).build();

    private static final MarshallingInfo<List> CCEMAILADDRESSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ccEmailAddresses").isBinary(false).build();

    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").isBinary(false).build();

    private static final MarshallingInfo<String> ISSUETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issueType").isBinary(false).build();

    private static final MarshallingInfo<String> ATTACHMENTSETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachmentSetId").isBinary(false).build();

    private static final CreateCaseRequestModelMarshaller INSTANCE = new CreateCaseRequestModelMarshaller();

    private CreateCaseRequestModelMarshaller() {
    }

    public static CreateCaseRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateCaseRequest createCaseRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createCaseRequest, "createCaseRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createCaseRequest.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall(createCaseRequest.serviceCode(), SERVICECODE_BINDING);
            protocolMarshaller.marshall(createCaseRequest.severityCode(), SEVERITYCODE_BINDING);
            protocolMarshaller.marshall(createCaseRequest.categoryCode(), CATEGORYCODE_BINDING);
            protocolMarshaller.marshall(createCaseRequest.communicationBody(), COMMUNICATIONBODY_BINDING);
            protocolMarshaller.marshall(createCaseRequest.ccEmailAddresses(), CCEMAILADDRESSES_BINDING);
            protocolMarshaller.marshall(createCaseRequest.language(), LANGUAGE_BINDING);
            protocolMarshaller.marshall(createCaseRequest.issueType(), ISSUETYPE_BINDING);
            protocolMarshaller.marshall(createCaseRequest.attachmentSetId(), ATTACHMENTSETID_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
