/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCheckResult;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link TrustedAdvisorCheckResult} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class TrustedAdvisorCheckResultMarshaller {
    private static final MarshallingInfo<String> CHECKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("checkId").isBinary(false).build();

    private static final MarshallingInfo<String> TIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RESOURCESSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("resourcesSummary").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CATEGORYSPECIFICSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("categorySpecificSummary").isBinary(false).build();

    private static final MarshallingInfo<List> FLAGGEDRESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("flaggedResources").isBinary(false).build();

    private static final TrustedAdvisorCheckResultMarshaller INSTANCE = new TrustedAdvisorCheckResultMarshaller();

    private TrustedAdvisorCheckResultMarshaller() {
    }

    public static TrustedAdvisorCheckResultMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(TrustedAdvisorCheckResult trustedAdvisorCheckResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(trustedAdvisorCheckResult, "trustedAdvisorCheckResult");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(trustedAdvisorCheckResult.checkId(), CHECKID_BINDING);
            protocolMarshaller.marshall(trustedAdvisorCheckResult.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall(trustedAdvisorCheckResult.status(), STATUS_BINDING);
            protocolMarshaller.marshall(trustedAdvisorCheckResult.resourcesSummary(), RESOURCESSUMMARY_BINDING);
            protocolMarshaller.marshall(trustedAdvisorCheckResult.categorySpecificSummary(), CATEGORYSPECIFICSUMMARY_BINDING);
            protocolMarshaller.marshall(trustedAdvisorCheckResult.flaggedResources(), FLAGGEDRESOURCES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
