/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.TrustedAdvisorResourcesSummary;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link TrustedAdvisorResourcesSummary} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class TrustedAdvisorResourcesSummaryMarshaller {
    private static final MarshallingInfo<Long> RESOURCESPROCESSED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesProcessed").isBinary(false).build();

    private static final MarshallingInfo<Long> RESOURCESFLAGGED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesFlagged").isBinary(false).build();

    private static final MarshallingInfo<Long> RESOURCESIGNORED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesIgnored").isBinary(false).build();

    private static final MarshallingInfo<Long> RESOURCESSUPPRESSED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesSuppressed").isBinary(false).build();

    private static final TrustedAdvisorResourcesSummaryMarshaller INSTANCE = new TrustedAdvisorResourcesSummaryMarshaller();

    private TrustedAdvisorResourcesSummaryMarshaller() {
    }

    public static TrustedAdvisorResourcesSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(TrustedAdvisorResourcesSummary trustedAdvisorResourcesSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(trustedAdvisorResourcesSummary, "trustedAdvisorResourcesSummary");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(trustedAdvisorResourcesSummary.resourcesProcessed(), RESOURCESPROCESSED_BINDING);
            protocolMarshaller.marshall(trustedAdvisorResourcesSummary.resourcesFlagged(), RESOURCESFLAGGED_BINDING);
            protocolMarshaller.marshall(trustedAdvisorResourcesSummary.resourcesIgnored(), RESOURCESIGNORED_BINDING);
            protocolMarshaller.marshall(trustedAdvisorResourcesSummary.resourcesSuppressed(), RESOURCESSUPPRESSED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
