/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustedAdvisorCheckSummariesRequest extends SupportRequest implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckSummariesRequest.Builder, DescribeTrustedAdvisorCheckSummariesRequest> {
    private static final SdkField<List<String>> CHECK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTrustedAdvisorCheckSummariesRequest::checkIds))
            .setter(setter(Builder::checkIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_IDS_FIELD));

    private final List<String> checkIds;

    private DescribeTrustedAdvisorCheckSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.checkIds = builder.checkIds;
    }

    /**
     * Returns true if the CheckIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCheckIds() {
        return checkIds != null && !(checkIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Trusted Advisor checks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCheckIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the Trusted Advisor checks.
     */
    public List<String> checkIds() {
        return checkIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(checkIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckSummariesRequest)) {
            return false;
        }
        DescribeTrustedAdvisorCheckSummariesRequest other = (DescribeTrustedAdvisorCheckSummariesRequest) obj;
        return Objects.equals(checkIds(), other.checkIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTrustedAdvisorCheckSummariesRequest").add("CheckIds", checkIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkIds":
            return Optional.ofNullable(clazz.cast(checkIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorCheckSummariesRequest, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorCheckSummariesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrustedAdvisorCheckSummariesRequest> {
        /**
         * <p>
         * The IDs of the Trusted Advisor checks.
         * </p>
         * 
         * @param checkIds
         *        The IDs of the Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIds(Collection<String> checkIds);

        /**
         * <p>
         * The IDs of the Trusted Advisor checks.
         * </p>
         * 
         * @param checkIds
         *        The IDs of the Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIds(String... checkIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private List<String> checkIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckSummariesRequest model) {
            super(model);
            checkIds(model.checkIds);
        }

        public final Collection<String> getCheckIds() {
            return checkIds;
        }

        @Override
        public final Builder checkIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIds(String... checkIds) {
            checkIds(Arrays.asList(checkIds));
            return this;
        }

        public final void setCheckIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrustedAdvisorCheckSummariesRequest build() {
            return new DescribeTrustedAdvisorCheckSummariesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
