/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ID and expiry time of the attachment set returned by the <a>AddAttachmentsToSet</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddAttachmentsToSetResponse extends SupportResponse implements
        ToCopyableBuilder<AddAttachmentsToSetResponse.Builder, AddAttachmentsToSetResponse> {
    private static final SdkField<String> ATTACHMENT_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddAttachmentsToSetResponse::attachmentSetId)).setter(setter(Builder::attachmentSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentSetId").build()).build();

    private static final SdkField<String> EXPIRY_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddAttachmentsToSetResponse::expiryTime)).setter(setter(Builder::expiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_SET_ID_FIELD,
            EXPIRY_TIME_FIELD));

    private final String attachmentSetId;

    private final String expiryTime;

    private AddAttachmentsToSetResponse(BuilderImpl builder) {
        super(builder);
        this.attachmentSetId = builder.attachmentSetId;
        this.expiryTime = builder.expiryTime;
    }

    /**
     * <p>
     * The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is
     * created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified, the
     * attachments are added to the specified set, if it exists.
     * </p>
     * 
     * @return The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set
     *         is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was
     *         specified, the attachments are added to the specified set, if it exists.
     */
    public String attachmentSetId() {
        return attachmentSetId;
    }

    /**
     * <p>
     * The time and date when the attachment set expires.
     * </p>
     * 
     * @return The time and date when the attachment set expires.
     */
    public String expiryTime() {
        return expiryTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentSetId());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAttachmentsToSetResponse)) {
            return false;
        }
        AddAttachmentsToSetResponse other = (AddAttachmentsToSetResponse) obj;
        return Objects.equals(attachmentSetId(), other.attachmentSetId()) && Objects.equals(expiryTime(), other.expiryTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddAttachmentsToSetResponse").add("AttachmentSetId", attachmentSetId())
                .add("ExpiryTime", expiryTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentSetId":
            return Optional.ofNullable(clazz.cast(attachmentSetId()));
        case "expiryTime":
            return Optional.ofNullable(clazz.cast(expiryTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddAttachmentsToSetResponse, T> g) {
        return obj -> g.apply((AddAttachmentsToSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo, CopyableBuilder<Builder, AddAttachmentsToSetResponse> {
        /**
         * <p>
         * The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is
         * created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified,
         * the attachments are added to the specified set, if it exists.
         * </p>
         * 
         * @param attachmentSetId
         *        The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment
         *        set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code>
         *        was specified, the attachments are added to the specified set, if it exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSetId(String attachmentSetId);

        /**
         * <p>
         * The time and date when the attachment set expires.
         * </p>
         * 
         * @param expiryTime
         *        The time and date when the attachment set expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTime(String expiryTime);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private String attachmentSetId;

        private String expiryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AddAttachmentsToSetResponse model) {
            super(model);
            attachmentSetId(model.attachmentSetId);
            expiryTime(model.expiryTime);
        }

        public final String getAttachmentSetId() {
            return attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        public final String getExpiryTime() {
            return expiryTime;
        }

        @Override
        public final Builder expiryTime(String expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final void setExpiryTime(String expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public AddAttachmentsToSetResponse build() {
            return new AddAttachmentsToSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
