/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a Trusted Advisor check result, including the alert status, last refresh, and number of resources
 * examined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorCheckSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustedAdvisorCheckSummary.Builder, TrustedAdvisorCheckSummary> {
    private static final SdkField<String> CHECK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrustedAdvisorCheckSummary::checkId)).setter(setter(Builder::checkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()).build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrustedAdvisorCheckSummary::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrustedAdvisorCheckSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> HAS_FLAGGED_RESOURCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TrustedAdvisorCheckSummary::hasFlaggedResources)).setter(setter(Builder::hasFlaggedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasFlaggedResources").build())
            .build();

    private static final SdkField<TrustedAdvisorResourcesSummary> RESOURCES_SUMMARY_FIELD = SdkField
            .<TrustedAdvisorResourcesSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(TrustedAdvisorCheckSummary::resourcesSummary)).setter(setter(Builder::resourcesSummary))
            .constructor(TrustedAdvisorResourcesSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesSummary").build()).build();

    private static final SdkField<TrustedAdvisorCategorySpecificSummary> CATEGORY_SPECIFIC_SUMMARY_FIELD = SdkField
            .<TrustedAdvisorCategorySpecificSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(TrustedAdvisorCheckSummary::categorySpecificSummary)).setter(setter(Builder::categorySpecificSummary))
            .constructor(TrustedAdvisorCategorySpecificSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categorySpecificSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CHECK_ID_FIELD, TIMESTAMP_FIELD, STATUS_FIELD, HAS_FLAGGED_RESOURCES_FIELD,
                    RESOURCES_SUMMARY_FIELD, CATEGORY_SPECIFIC_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String checkId;

    private final String timestamp;

    private final String status;

    private final Boolean hasFlaggedResources;

    private final TrustedAdvisorResourcesSummary resourcesSummary;

    private final TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

    private TrustedAdvisorCheckSummary(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.hasFlaggedResources = builder.hasFlaggedResources;
        this.resourcesSummary = builder.resourcesSummary;
        this.categorySpecificSummary = builder.categorySpecificSummary;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The time of the last refresh of the check.
     * </p>
     * 
     * @return The time of the last refresh of the check.
     */
    public String timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     * </p>
     * 
     * @return The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Specifies whether the Trusted Advisor check has flagged resources.
     * </p>
     * 
     * @return Specifies whether the Trusted Advisor check has flagged resources.
     */
    public Boolean hasFlaggedResources() {
        return hasFlaggedResources;
    }

    /**
     * Returns the value of the ResourcesSummary property for this object.
     * 
     * @return The value of the ResourcesSummary property for this object.
     */
    public TrustedAdvisorResourcesSummary resourcesSummary() {
        return resourcesSummary;
    }

    /**
     * <p>
     * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
     * currently supported.
     * </p>
     * 
     * @return Summary information that relates to the category of the check. Cost Optimizing is the only category that
     *         is currently supported.
     */
    public TrustedAdvisorCategorySpecificSummary categorySpecificSummary() {
        return categorySpecificSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkId());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasFlaggedResources());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(categorySpecificSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckSummary)) {
            return false;
        }
        TrustedAdvisorCheckSummary other = (TrustedAdvisorCheckSummary) obj;
        return Objects.equals(checkId(), other.checkId()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(status(), other.status()) && Objects.equals(hasFlaggedResources(), other.hasFlaggedResources())
                && Objects.equals(resourcesSummary(), other.resourcesSummary())
                && Objects.equals(categorySpecificSummary(), other.categorySpecificSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrustedAdvisorCheckSummary").add("CheckId", checkId()).add("Timestamp", timestamp())
                .add("Status", status()).add("HasFlaggedResources", hasFlaggedResources())
                .add("ResourcesSummary", resourcesSummary()).add("CategorySpecificSummary", categorySpecificSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkId":
            return Optional.ofNullable(clazz.cast(checkId()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "hasFlaggedResources":
            return Optional.ofNullable(clazz.cast(hasFlaggedResources()));
        case "resourcesSummary":
            return Optional.ofNullable(clazz.cast(resourcesSummary()));
        case "categorySpecificSummary":
            return Optional.ofNullable(clazz.cast(categorySpecificSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorCheckSummary, T> g) {
        return obj -> g.apply((TrustedAdvisorCheckSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustedAdvisorCheckSummary> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The time of the last refresh of the check.
         * </p>
         * 
         * @param timestamp
         *        The time of the last refresh of the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);

        /**
         * <p>
         * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * </p>
         * 
         * @param status
         *        The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether the Trusted Advisor check has flagged resources.
         * </p>
         * 
         * @param hasFlaggedResources
         *        Specifies whether the Trusted Advisor check has flagged resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasFlaggedResources(Boolean hasFlaggedResources);

        /**
         * Sets the value of the ResourcesSummary property for this object.
         *
         * @param resourcesSummary
         *        The new value for the ResourcesSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary);

        /**
         * Sets the value of the ResourcesSummary property for this object.
         *
         * This is a convenience that creates an instance of the {@link TrustedAdvisorResourcesSummary.Builder} avoiding
         * the need to create one manually via {@link TrustedAdvisorResourcesSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedAdvisorResourcesSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #resourcesSummary(TrustedAdvisorResourcesSummary)}.
         * 
         * @param resourcesSummary
         *        a consumer that will call methods on {@link TrustedAdvisorResourcesSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesSummary(TrustedAdvisorResourcesSummary)
         */
        default Builder resourcesSummary(Consumer<TrustedAdvisorResourcesSummary.Builder> resourcesSummary) {
            return resourcesSummary(TrustedAdvisorResourcesSummary.builder().applyMutation(resourcesSummary).build());
        }

        /**
         * <p>
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
         * currently supported.
         * </p>
         * 
         * @param categorySpecificSummary
         *        Summary information that relates to the category of the check. Cost Optimizing is the only category
         *        that is currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary);

        /**
         * <p>
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
         * currently supported.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedAdvisorCategorySpecificSummary.Builder}
         * avoiding the need to create one manually via {@link TrustedAdvisorCategorySpecificSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedAdvisorCategorySpecificSummary.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #categorySpecificSummary(TrustedAdvisorCategorySpecificSummary)}.
         * 
         * @param categorySpecificSummary
         *        a consumer that will call methods on {@link TrustedAdvisorCategorySpecificSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categorySpecificSummary(TrustedAdvisorCategorySpecificSummary)
         */
        default Builder categorySpecificSummary(Consumer<TrustedAdvisorCategorySpecificSummary.Builder> categorySpecificSummary) {
            return categorySpecificSummary(TrustedAdvisorCategorySpecificSummary.builder().applyMutation(categorySpecificSummary)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String checkId;

        private String timestamp;

        private String status;

        private Boolean hasFlaggedResources;

        private TrustedAdvisorResourcesSummary resourcesSummary;

        private TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckSummary model) {
            checkId(model.checkId);
            timestamp(model.timestamp);
            status(model.status);
            hasFlaggedResources(model.hasFlaggedResources);
            resourcesSummary(model.resourcesSummary);
            categorySpecificSummary(model.categorySpecificSummary);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getHasFlaggedResources() {
            return hasFlaggedResources;
        }

        @Override
        public final Builder hasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
            return this;
        }

        public final void setHasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
        }

        public final TrustedAdvisorResourcesSummary.Builder getResourcesSummary() {
            return resourcesSummary != null ? resourcesSummary.toBuilder() : null;
        }

        @Override
        public final Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary) {
            this.resourcesSummary = resourcesSummary;
            return this;
        }

        public final void setResourcesSummary(TrustedAdvisorResourcesSummary.BuilderImpl resourcesSummary) {
            this.resourcesSummary = resourcesSummary != null ? resourcesSummary.build() : null;
        }

        public final TrustedAdvisorCategorySpecificSummary.Builder getCategorySpecificSummary() {
            return categorySpecificSummary != null ? categorySpecificSummary.toBuilder() : null;
        }

        @Override
        public final Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
            return this;
        }

        public final void setCategorySpecificSummary(TrustedAdvisorCategorySpecificSummary.BuilderImpl categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary != null ? categorySpecificSummary.build() : null;
        }

        @Override
        public TrustedAdvisorCheckSummary build() {
            return new TrustedAdvisorCheckSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
