/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON-formatted object that contains the metadata for a support case. It is contained the response from a
 * <a>DescribeCases</a> request. <b>CaseDetails</b> contains the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>caseId.</b> The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
 * formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>categoryCode.</b> The category of problem for the AWS Support case. Corresponds to the CategoryCode values
 * returned by a call to <a>DescribeServices</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>displayId.</b> The identifier for the case on pages in the AWS Support Center.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>language.</b> The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
 * English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>recentCommunications.</b> One or more <a>Communication</a> objects. Fields of these objects are
 * <code>attachments</code>, <code>body</code>, <code>caseId</code>, <code>submittedBy</code>, and
 * <code>timeCreated</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>nextToken.</b> A resumption point for pagination.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>serviceCode.</b> The identifier for the AWS service that corresponds to the service code defined in the call to
 * <a>DescribeServices</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>severityCode.</b> The severity code assigned to the case. Contains one of the values returned by the call to
 * <a>DescribeSeverityLevels</a>. The possible values are: <code>low</code>, <code>normal</code>, <code>high</code>,
 * <code>urgent</code>, and <code>critical</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>status.</b> The status of the case in the AWS Support Center. The possible values are: <code>resolved</code>,
 * <code>pending-customer-action</code>, <code>opened</code>, <code>unassigned</code>, and <code>work-in-progress</code>
 * .
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>subject.</b> The subject line of the case.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>submittedBy.</b> The email address of the account that submitted the case.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>timeCreated.</b> The time the case was created, in ISO-8601 format.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaseDetails implements SdkPojo, Serializable, ToCopyableBuilder<CaseDetails.Builder, CaseDetails> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseId").build()).build();

    private static final SdkField<String> DISPLAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::displayId)).setter(setter(Builder::displayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayId").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> CATEGORY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::categoryCode)).setter(setter(Builder::categoryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoryCode").build()).build();

    private static final SdkField<String> SEVERITY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::severityCode)).setter(setter(Builder::severityCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCode").build()).build();

    private static final SdkField<String> SUBMITTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::submittedBy)).setter(setter(Builder::submittedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedBy").build()).build();

    private static final SdkField<String> TIME_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::timeCreated)).setter(setter(Builder::timeCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeCreated").build()).build();

    private static final SdkField<RecentCaseCommunications> RECENT_COMMUNICATIONS_FIELD = SdkField
            .<RecentCaseCommunications> builder(MarshallingType.SDK_POJO).getter(getter(CaseDetails::recentCommunications))
            .setter(setter(Builder::recentCommunications)).constructor(RecentCaseCommunications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recentCommunications").build())
            .build();

    private static final SdkField<List<String>> CC_EMAIL_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CaseDetails::ccEmailAddresses))
            .setter(setter(Builder::ccEmailAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccEmailAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaseDetails::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD,
            DISPLAY_ID_FIELD, SUBJECT_FIELD, STATUS_FIELD, SERVICE_CODE_FIELD, CATEGORY_CODE_FIELD, SEVERITY_CODE_FIELD,
            SUBMITTED_BY_FIELD, TIME_CREATED_FIELD, RECENT_COMMUNICATIONS_FIELD, CC_EMAIL_ADDRESSES_FIELD, LANGUAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String caseId;

    private final String displayId;

    private final String subject;

    private final String status;

    private final String serviceCode;

    private final String categoryCode;

    private final String severityCode;

    private final String submittedBy;

    private final String timeCreated;

    private final RecentCaseCommunications recentCommunications;

    private final List<String> ccEmailAddresses;

    private final String language;

    private CaseDetails(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.displayId = builder.displayId;
        this.subject = builder.subject;
        this.status = builder.status;
        this.serviceCode = builder.serviceCode;
        this.categoryCode = builder.categoryCode;
        this.severityCode = builder.severityCode;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.recentCommunications = builder.recentCommunications;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
    }

    /**
     * <p>
     * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
     * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     * </p>
     * 
     * @return The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
     *         formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     */
    public String caseId() {
        return caseId;
    }

    /**
     * <p>
     * The ID displayed for the case in the AWS Support Center. This is a numeric string.
     * </p>
     * 
     * @return The ID displayed for the case in the AWS Support Center. This is a numeric string.
     */
    public String displayId() {
        return displayId;
    }

    /**
     * <p>
     * The subject line for the case in the AWS Support Center.
     * </p>
     * 
     * @return The subject line for the case in the AWS Support Center.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * The status of the case. Valid values: <code>resolved</code> | <code>pending-customer-action</code> |
     * <code>opened</code> | <code>unassigned</code> | <code>work-in-progress</code>.
     * </p>
     * 
     * @return The status of the case. Valid values: <code>resolved</code> | <code>pending-customer-action</code> |
     *         <code>opened</code> | <code>unassigned</code> | <code>work-in-progress</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The code for the AWS service. You can get a list of codes and the corresponding service names by calling
     * <a>DescribeServices</a>.
     * </p>
     * 
     * @return The code for the AWS service. You can get a list of codes and the corresponding service names by calling
     *         <a>DescribeServices</a>.
     */
    public String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The category of problem for the AWS Support case.
     * </p>
     * 
     * @return The category of problem for the AWS Support case.
     */
    public String categoryCode() {
        return categoryCode;
    }

    /**
     * <p>
     * The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
     * </p>
     * 
     * @return The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
     */
    public String severityCode() {
        return severityCode;
    }

    /**
     * <p>
     * The email address of the account that submitted the case.
     * </p>
     * 
     * @return The email address of the account that submitted the case.
     */
    public String submittedBy() {
        return submittedBy;
    }

    /**
     * <p>
     * The time that the case was case created in the AWS Support Center.
     * </p>
     * 
     * @return The time that the case was case created in the AWS Support Center.
     */
    public String timeCreated() {
        return timeCreated;
    }

    /**
     * <p>
     * The five most recent communications between you and AWS Support Center, including the IDs of any attachments to
     * the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier communications.
     * </p>
     * 
     * @return The five most recent communications between you and AWS Support Center, including the IDs of any
     *         attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve
     *         earlier communications.
     */
    public RecentCaseCommunications recentCommunications() {
        return recentCommunications;
    }

    /**
     * Returns true if the CcEmailAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCcEmailAddresses() {
        return ccEmailAddresses != null && !(ccEmailAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The email addresses that receive copies of communication about the case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCcEmailAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The email addresses that receive copies of communication about the case.
     */
    public List<String> ccEmailAddresses() {
        return ccEmailAddresses;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(displayId());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(categoryCode());
        hashCode = 31 * hashCode + Objects.hashCode(severityCode());
        hashCode = 31 * hashCode + Objects.hashCode(submittedBy());
        hashCode = 31 * hashCode + Objects.hashCode(timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(recentCommunications());
        hashCode = 31 * hashCode + Objects.hashCode(ccEmailAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseDetails)) {
            return false;
        }
        CaseDetails other = (CaseDetails) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(displayId(), other.displayId())
                && Objects.equals(subject(), other.subject()) && Objects.equals(status(), other.status())
                && Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(categoryCode(), other.categoryCode())
                && Objects.equals(severityCode(), other.severityCode()) && Objects.equals(submittedBy(), other.submittedBy())
                && Objects.equals(timeCreated(), other.timeCreated())
                && Objects.equals(recentCommunications(), other.recentCommunications())
                && Objects.equals(ccEmailAddresses(), other.ccEmailAddresses()) && Objects.equals(language(), other.language());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CaseDetails").add("CaseId", caseId()).add("DisplayId", displayId()).add("Subject", subject())
                .add("Status", status()).add("ServiceCode", serviceCode()).add("CategoryCode", categoryCode())
                .add("SeverityCode", severityCode()).add("SubmittedBy", submittedBy()).add("TimeCreated", timeCreated())
                .add("RecentCommunications", recentCommunications()).add("CcEmailAddresses", ccEmailAddresses())
                .add("Language", language()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "displayId":
            return Optional.ofNullable(clazz.cast(displayId()));
        case "subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "categoryCode":
            return Optional.ofNullable(clazz.cast(categoryCode()));
        case "severityCode":
            return Optional.ofNullable(clazz.cast(severityCode()));
        case "submittedBy":
            return Optional.ofNullable(clazz.cast(submittedBy()));
        case "timeCreated":
            return Optional.ofNullable(clazz.cast(timeCreated()));
        case "recentCommunications":
            return Optional.ofNullable(clazz.cast(recentCommunications()));
        case "ccEmailAddresses":
            return Optional.ofNullable(clazz.cast(ccEmailAddresses()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaseDetails, T> g) {
        return obj -> g.apply((CaseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaseDetails> {
        /**
         * <p>
         * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
         * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * </p>
         * 
         * @param caseId
         *        The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
         *        formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * The ID displayed for the case in the AWS Support Center. This is a numeric string.
         * </p>
         * 
         * @param displayId
         *        The ID displayed for the case in the AWS Support Center. This is a numeric string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayId(String displayId);

        /**
         * <p>
         * The subject line for the case in the AWS Support Center.
         * </p>
         * 
         * @param subject
         *        The subject line for the case in the AWS Support Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The status of the case. Valid values: <code>resolved</code> | <code>pending-customer-action</code> |
         * <code>opened</code> | <code>unassigned</code> | <code>work-in-progress</code>.
         * </p>
         * 
         * @param status
         *        The status of the case. Valid values: <code>resolved</code> | <code>pending-customer-action</code> |
         *        <code>opened</code> | <code>unassigned</code> | <code>work-in-progress</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The code for the AWS service. You can get a list of codes and the corresponding service names by calling
         * <a>DescribeServices</a>.
         * </p>
         * 
         * @param serviceCode
         *        The code for the AWS service. You can get a list of codes and the corresponding service names by
         *        calling <a>DescribeServices</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The category of problem for the AWS Support case.
         * </p>
         * 
         * @param categoryCode
         *        The category of problem for the AWS Support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryCode(String categoryCode);

        /**
         * <p>
         * The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
         * </p>
         * 
         * @param severityCode
         *        The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCode(String severityCode);

        /**
         * <p>
         * The email address of the account that submitted the case.
         * </p>
         * 
         * @param submittedBy
         *        The email address of the account that submitted the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedBy(String submittedBy);

        /**
         * <p>
         * The time that the case was case created in the AWS Support Center.
         * </p>
         * 
         * @param timeCreated
         *        The time that the case was case created in the AWS Support Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCreated(String timeCreated);

        /**
         * <p>
         * The five most recent communications between you and AWS Support Center, including the IDs of any attachments
         * to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier
         * communications.
         * </p>
         * 
         * @param recentCommunications
         *        The five most recent communications between you and AWS Support Center, including the IDs of any
         *        attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve
         *        earlier communications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recentCommunications(RecentCaseCommunications recentCommunications);

        /**
         * <p>
         * The five most recent communications between you and AWS Support Center, including the IDs of any attachments
         * to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier
         * communications.
         * </p>
         * This is a convenience that creates an instance of the {@link RecentCaseCommunications.Builder} avoiding the
         * need to create one manually via {@link RecentCaseCommunications#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecentCaseCommunications.Builder#build()} is called immediately
         * and its result is passed to {@link #recentCommunications(RecentCaseCommunications)}.
         * 
         * @param recentCommunications
         *        a consumer that will call methods on {@link RecentCaseCommunications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recentCommunications(RecentCaseCommunications)
         */
        default Builder recentCommunications(Consumer<RecentCaseCommunications.Builder> recentCommunications) {
            return recentCommunications(RecentCaseCommunications.builder().applyMutation(recentCommunications).build());
        }

        /**
         * <p>
         * The email addresses that receive copies of communication about the case.
         * </p>
         * 
         * @param ccEmailAddresses
         *        The email addresses that receive copies of communication about the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(Collection<String> ccEmailAddresses);

        /**
         * <p>
         * The email addresses that receive copies of communication about the case.
         * </p>
         * 
         * @param ccEmailAddresses
         *        The email addresses that receive copies of communication about the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(String... ccEmailAddresses);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);
    }

    static final class BuilderImpl implements Builder {
        private String caseId;

        private String displayId;

        private String subject;

        private String status;

        private String serviceCode;

        private String categoryCode;

        private String severityCode;

        private String submittedBy;

        private String timeCreated;

        private RecentCaseCommunications recentCommunications;

        private List<String> ccEmailAddresses = DefaultSdkAutoConstructList.getInstance();

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseDetails model) {
            caseId(model.caseId);
            displayId(model.displayId);
            subject(model.subject);
            status(model.status);
            serviceCode(model.serviceCode);
            categoryCode(model.categoryCode);
            severityCode(model.severityCode);
            submittedBy(model.submittedBy);
            timeCreated(model.timeCreated);
            recentCommunications(model.recentCommunications);
            ccEmailAddresses(model.ccEmailAddresses);
            language(model.language);
        }

        public final String getCaseId() {
            return caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getDisplayId() {
            return displayId;
        }

        @Override
        public final Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final void setDisplayId(String displayId) {
            this.displayId = displayId;
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getCategoryCode() {
            return categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        public final String getSeverityCode() {
            return severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        public final String getSubmittedBy() {
            return submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        public final String getTimeCreated() {
            return timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final RecentCaseCommunications.Builder getRecentCommunications() {
            return recentCommunications != null ? recentCommunications.toBuilder() : null;
        }

        @Override
        public final Builder recentCommunications(RecentCaseCommunications recentCommunications) {
            this.recentCommunications = recentCommunications;
            return this;
        }

        public final void setRecentCommunications(RecentCaseCommunications.BuilderImpl recentCommunications) {
            this.recentCommunications = recentCommunications != null ? recentCommunications.build() : null;
        }

        public final Collection<String> getCcEmailAddresses() {
            return ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String... ccEmailAddresses) {
            ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public CaseDetails build() {
            return new CaseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
