/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.support.SupportClient;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetRequest;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetResponse;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseRequest;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseResponse;
import software.amazon.awssdk.services.support.model.AttachmentIdNotFoundException;
import software.amazon.awssdk.services.support.model.AttachmentLimitExceededException;
import software.amazon.awssdk.services.support.model.AttachmentSetExpiredException;
import software.amazon.awssdk.services.support.model.AttachmentSetIdNotFoundException;
import software.amazon.awssdk.services.support.model.AttachmentSetSizeLimitExceededException;
import software.amazon.awssdk.services.support.model.CaseCreationLimitExceededException;
import software.amazon.awssdk.services.support.model.CaseIdNotFoundException;
import software.amazon.awssdk.services.support.model.CreateCaseRequest;
import software.amazon.awssdk.services.support.model.CreateCaseResponse;
import software.amazon.awssdk.services.support.model.DescribeAttachmentLimitExceededException;
import software.amazon.awssdk.services.support.model.DescribeAttachmentRequest;
import software.amazon.awssdk.services.support.model.DescribeAttachmentResponse;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.services.support.model.DescribeCasesResponse;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse;
import software.amazon.awssdk.services.support.model.DescribeServicesRequest;
import software.amazon.awssdk.services.support.model.DescribeServicesResponse;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsRequest;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksResponse;
import software.amazon.awssdk.services.support.model.InternalServerErrorException;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckRequest;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckResponse;
import software.amazon.awssdk.services.support.model.ResolveCaseRequest;
import software.amazon.awssdk.services.support.model.ResolveCaseResponse;
import software.amazon.awssdk.services.support.model.SupportException;
import software.amazon.awssdk.services.support.model.SupportRequest;
import software.amazon.awssdk.services.support.paginators.DescribeCasesIterable;
import software.amazon.awssdk.services.support.paginators.DescribeCommunicationsIterable;
import software.amazon.awssdk.services.support.transform.AddAttachmentsToSetRequestMarshaller;
import software.amazon.awssdk.services.support.transform.AddCommunicationToCaseRequestMarshaller;
import software.amazon.awssdk.services.support.transform.CreateCaseRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeAttachmentRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCasesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCommunicationsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeSeverityLevelsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckResultRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckSummariesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorChecksRequestMarshaller;
import software.amazon.awssdk.services.support.transform.RefreshTrustedAdvisorCheckRequestMarshaller;
import software.amazon.awssdk.services.support.transform.ResolveCaseRequestMarshaller;

@SdkInternalApi
final class DefaultSupportClient
implements SupportClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSupportClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "support";
    }

    @Override
    public AddAttachmentsToSetResponse addAttachmentsToSet(AddAttachmentsToSetRequest addAttachmentsToSetRequest) throws InternalServerErrorException, AttachmentSetIdNotFoundException, AttachmentSetExpiredException, AttachmentSetSizeLimitExceededException, AttachmentLimitExceededException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddAttachmentsToSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddAttachmentsToSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddAttachmentsToSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addAttachmentsToSetRequest).withMarshaller((Marshaller)new AddAttachmentsToSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AddCommunicationToCaseResponse addCommunicationToCase(AddCommunicationToCaseRequest addCommunicationToCaseRequest) throws InternalServerErrorException, CaseIdNotFoundException, AttachmentSetIdNotFoundException, AttachmentSetExpiredException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddCommunicationToCaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddCommunicationToCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddCommunicationToCase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addCommunicationToCaseRequest).withMarshaller((Marshaller)new AddCommunicationToCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateCaseResponse createCase(CreateCaseRequest createCaseRequest) throws InternalServerErrorException, CaseCreationLimitExceededException, AttachmentSetIdNotFoundException, AttachmentSetExpiredException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCaseRequest).withMarshaller((Marshaller)new CreateCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAttachmentResponse describeAttachment(DescribeAttachmentRequest describeAttachmentRequest) throws InternalServerErrorException, DescribeAttachmentLimitExceededException, AttachmentIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAttachmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAttachmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAttachment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAttachmentRequest).withMarshaller((Marshaller)new DescribeAttachmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeCasesResponse describeCases(DescribeCasesRequest describeCasesRequest) throws InternalServerErrorException, CaseIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeCasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCasesRequest).withMarshaller((Marshaller)new DescribeCasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeCasesIterable describeCasesPaginator(DescribeCasesRequest describeCasesRequest) throws InternalServerErrorException, CaseIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        return new DescribeCasesIterable(this, this.applyPaginatorUserAgent(describeCasesRequest));
    }

    @Override
    public DescribeCommunicationsResponse describeCommunications(DescribeCommunicationsRequest describeCommunicationsRequest) throws InternalServerErrorException, CaseIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCommunicationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeCommunicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCommunications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCommunicationsRequest).withMarshaller((Marshaller)new DescribeCommunicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeCommunicationsIterable describeCommunicationsPaginator(DescribeCommunicationsRequest describeCommunicationsRequest) throws InternalServerErrorException, CaseIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        return new DescribeCommunicationsIterable(this, this.applyPaginatorUserAgent(describeCommunicationsRequest));
    }

    @Override
    public DescribeServicesResponse describeServices(DescribeServicesRequest describeServicesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServicesRequest).withMarshaller((Marshaller)new DescribeServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeSeverityLevelsResponse describeSeverityLevels(DescribeSeverityLevelsRequest describeSeverityLevelsRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSeverityLevelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeSeverityLevelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSeverityLevels").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSeverityLevelsRequest).withMarshaller((Marshaller)new DescribeSeverityLevelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeTrustedAdvisorCheckRefreshStatusesResponse describeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorCheckRefreshStatusesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeTrustedAdvisorCheckRefreshStatusesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorCheckRefreshStatuses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrustedAdvisorCheckRefreshStatusesRequest).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeTrustedAdvisorCheckResultResponse describeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorCheckResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeTrustedAdvisorCheckResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorCheckResult").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrustedAdvisorCheckResultRequest).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeTrustedAdvisorCheckSummariesResponse describeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorCheckSummariesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeTrustedAdvisorCheckSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorCheckSummaries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrustedAdvisorCheckSummariesRequest).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeTrustedAdvisorChecksResponse describeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorChecksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeTrustedAdvisorChecksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorChecks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrustedAdvisorChecksRequest).withMarshaller((Marshaller)new DescribeTrustedAdvisorChecksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RefreshTrustedAdvisorCheckResponse refreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RefreshTrustedAdvisorCheckResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RefreshTrustedAdvisorCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RefreshTrustedAdvisorCheck").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)refreshTrustedAdvisorCheckRequest).withMarshaller((Marshaller)new RefreshTrustedAdvisorCheckRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ResolveCaseResponse resolveCase(ResolveCaseRequest resolveCaseRequest) throws InternalServerErrorException, CaseIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResolveCaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ResolveCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResolveCase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resolveCaseRequest).withMarshaller((Marshaller)new ResolveCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SupportException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CaseIdNotFound").exceptionBuilderSupplier(CaseIdNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SupportRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.68").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SupportRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

