/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustedAdvisorCheckResultRequest extends SupportRequest implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckResultRequest.Builder, DescribeTrustedAdvisorCheckResultRequest> {
    private static final SdkField<String> CHECK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTrustedAdvisorCheckResultRequest::checkId)).setter(setter(Builder::checkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTrustedAdvisorCheckResultRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CHECK_ID_FIELD, LANGUAGE_FIELD));

    private final String checkId;

    private final String language;

    private DescribeTrustedAdvisorCheckResultRequest(BuilderImpl builder) {
        super(builder);
        this.checkId = builder.checkId;
        this.language = builder.language;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(checkId());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckResultRequest)) {
            return false;
        }
        DescribeTrustedAdvisorCheckResultRequest other = (DescribeTrustedAdvisorCheckResultRequest) obj;
        return Objects.equals(checkId(), other.checkId()) && Objects.equals(language(), other.language());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTrustedAdvisorCheckResultRequest").add("CheckId", checkId()).add("Language", language())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkId":
            return Optional.ofNullable(clazz.cast(checkId()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorCheckResultRequest, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorCheckResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrustedAdvisorCheckResultRequest> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private String checkId;

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckResultRequest model) {
            super(model);
            checkId(model.checkId);
            language(model.language);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrustedAdvisorCheckResultRequest build() {
            return new DescribeTrustedAdvisorCheckResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
