/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddCommunicationToCaseRequest extends SupportRequest implements
        ToCopyableBuilder<AddCommunicationToCaseRequest.Builder, AddCommunicationToCaseRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(AddCommunicationToCaseRequest::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseId").build()).build();

    private static final SdkField<String> COMMUNICATION_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("communicationBody").getter(getter(AddCommunicationToCaseRequest::communicationBody))
            .setter(setter(Builder::communicationBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationBody").build()).build();

    private static final SdkField<List<String>> CC_EMAIL_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ccEmailAddresses")
            .getter(getter(AddCommunicationToCaseRequest::ccEmailAddresses))
            .setter(setter(Builder::ccEmailAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccEmailAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ATTACHMENT_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentSetId").getter(getter(AddCommunicationToCaseRequest::attachmentSetId))
            .setter(setter(Builder::attachmentSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD,
            COMMUNICATION_BODY_FIELD, CC_EMAIL_ADDRESSES_FIELD, ATTACHMENT_SET_ID_FIELD));

    private final String caseId;

    private final String communicationBody;

    private final List<String> ccEmailAddresses;

    private final String attachmentSetId;

    private AddCommunicationToCaseRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.communicationBody = builder.communicationBody;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.attachmentSetId = builder.attachmentSetId;
    }

    /**
     * <p>
     * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
     * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     * </p>
     * 
     * @return The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
     *         formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     */
    public String caseId() {
        return caseId;
    }

    /**
     * <p>
     * The body of an email communication to add to the support case.
     * </p>
     * 
     * @return The body of an email communication to add to the support case.
     */
    public String communicationBody() {
        return communicationBody;
    }

    /**
     * Returns true if the CcEmailAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCcEmailAddresses() {
        return ccEmailAddresses != null && !(ccEmailAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The email addresses in the CC line of an email to be added to the support case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCcEmailAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The email addresses in the CC line of an email to be added to the support case.
     */
    public List<String> ccEmailAddresses() {
        return ccEmailAddresses;
    }

    /**
     * <p>
     * The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling
     * <a>AddAttachmentsToSet</a>
     * </p>
     * 
     * @return The ID of a set of one or more attachments for the communication to add to the case. Create the set by
     *         calling <a>AddAttachmentsToSet</a>
     */
    public String attachmentSetId() {
        return attachmentSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(communicationBody());
        hashCode = 31 * hashCode + Objects.hashCode(ccEmailAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentSetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCommunicationToCaseRequest)) {
            return false;
        }
        AddCommunicationToCaseRequest other = (AddCommunicationToCaseRequest) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(communicationBody(), other.communicationBody())
                && Objects.equals(ccEmailAddresses(), other.ccEmailAddresses())
                && Objects.equals(attachmentSetId(), other.attachmentSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddCommunicationToCaseRequest").add("CaseId", caseId())
                .add("CommunicationBody", communicationBody()).add("CcEmailAddresses", ccEmailAddresses())
                .add("AttachmentSetId", attachmentSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "communicationBody":
            return Optional.ofNullable(clazz.cast(communicationBody()));
        case "ccEmailAddresses":
            return Optional.ofNullable(clazz.cast(ccEmailAddresses()));
        case "attachmentSetId":
            return Optional.ofNullable(clazz.cast(attachmentSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddCommunicationToCaseRequest, T> g) {
        return obj -> g.apply((AddCommunicationToCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddCommunicationToCaseRequest> {
        /**
         * <p>
         * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
         * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * </p>
         * 
         * @param caseId
         *        The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
         *        formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * The body of an email communication to add to the support case.
         * </p>
         * 
         * @param communicationBody
         *        The body of an email communication to add to the support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationBody(String communicationBody);

        /**
         * <p>
         * The email addresses in the CC line of an email to be added to the support case.
         * </p>
         * 
         * @param ccEmailAddresses
         *        The email addresses in the CC line of an email to be added to the support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(Collection<String> ccEmailAddresses);

        /**
         * <p>
         * The email addresses in the CC line of an email to be added to the support case.
         * </p>
         * 
         * @param ccEmailAddresses
         *        The email addresses in the CC line of an email to be added to the support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(String... ccEmailAddresses);

        /**
         * <p>
         * The ID of a set of one or more attachments for the communication to add to the case. Create the set by
         * calling <a>AddAttachmentsToSet</a>
         * </p>
         * 
         * @param attachmentSetId
         *        The ID of a set of one or more attachments for the communication to add to the case. Create the set by
         *        calling <a>AddAttachmentsToSet</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSetId(String attachmentSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private String caseId;

        private String communicationBody;

        private List<String> ccEmailAddresses = DefaultSdkAutoConstructList.getInstance();

        private String attachmentSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddCommunicationToCaseRequest model) {
            super(model);
            caseId(model.caseId);
            communicationBody(model.communicationBody);
            ccEmailAddresses(model.ccEmailAddresses);
            attachmentSetId(model.attachmentSetId);
        }

        public final String getCaseId() {
            return caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getCommunicationBody() {
            return communicationBody;
        }

        @Override
        public final Builder communicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
            return this;
        }

        public final void setCommunicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
        }

        public final Collection<String> getCcEmailAddresses() {
            return ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String... ccEmailAddresses) {
            ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        public final String getAttachmentSetId() {
            return attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddCommunicationToCaseRequest build() {
            return new AddCommunicationToCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
