/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The refresh status of a Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorCheckRefreshStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustedAdvisorCheckRefreshStatus.Builder, TrustedAdvisorCheckRefreshStatus> {
    private static final SdkField<String> CHECK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkId").getter(getter(TrustedAdvisorCheckRefreshStatus::checkId)).setter(setter(Builder::checkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TrustedAdvisorCheckRefreshStatus::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Long> MILLIS_UNTIL_NEXT_REFRESHABLE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("millisUntilNextRefreshable")
            .getter(getter(TrustedAdvisorCheckRefreshStatus::millisUntilNextRefreshable))
            .setter(setter(Builder::millisUntilNextRefreshable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("millisUntilNextRefreshable").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_ID_FIELD, STATUS_FIELD,
            MILLIS_UNTIL_NEXT_REFRESHABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String checkId;

    private final String status;

    private final Long millisUntilNextRefreshable;

    private TrustedAdvisorCheckRefreshStatus(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.status = builder.status;
        this.millisUntilNextRefreshable = builder.millisUntilNextRefreshable;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public final String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The status of the Trusted Advisor check for which a refresh has been requested:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>none:</code> The check is not refreshed or the non-success status exceeds the timeout
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>enqueued:</code> The check refresh requests has entered the refresh queue
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>processing:</code> The check refresh request is picked up by the rule processing engine
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>success:</code> The check is successfully refreshed
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>abandoned:</code> The check refresh has failed
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the Trusted Advisor check for which a refresh has been requested: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>none:</code> The check is not refreshed or the non-success status exceeds the timeout
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>enqueued:</code> The check refresh requests has entered the refresh queue
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>processing:</code> The check refresh request is picked up by the rule processing engine
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>success:</code> The check is successfully refreshed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>abandoned:</code> The check refresh has failed
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
     * </p>
     * 
     * @return The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
     */
    public final Long millisUntilNextRefreshable() {
        return millisUntilNextRefreshable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(millisUntilNextRefreshable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckRefreshStatus)) {
            return false;
        }
        TrustedAdvisorCheckRefreshStatus other = (TrustedAdvisorCheckRefreshStatus) obj;
        return Objects.equals(checkId(), other.checkId()) && Objects.equals(status(), other.status())
                && Objects.equals(millisUntilNextRefreshable(), other.millisUntilNextRefreshable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustedAdvisorCheckRefreshStatus").add("CheckId", checkId()).add("Status", status())
                .add("MillisUntilNextRefreshable", millisUntilNextRefreshable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkId":
            return Optional.ofNullable(clazz.cast(checkId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "millisUntilNextRefreshable":
            return Optional.ofNullable(clazz.cast(millisUntilNextRefreshable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorCheckRefreshStatus, T> g) {
        return obj -> g.apply((TrustedAdvisorCheckRefreshStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustedAdvisorCheckRefreshStatus> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The status of the Trusted Advisor check for which a refresh has been requested:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>none:</code> The check is not refreshed or the non-success status exceeds the timeout
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enqueued:</code> The check refresh requests has entered the refresh queue
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>processing:</code> The check refresh request is picked up by the rule processing engine
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>success:</code> The check is successfully refreshed
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>abandoned:</code> The check refresh has failed
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Trusted Advisor check for which a refresh has been requested: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>none:</code> The check is not refreshed or the non-success status exceeds the timeout
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enqueued:</code> The check refresh requests has entered the refresh queue
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>processing:</code> The check refresh request is picked up by the rule processing engine
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>success:</code> The check is successfully refreshed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>abandoned:</code> The check refresh has failed
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
         * </p>
         * 
         * @param millisUntilNextRefreshable
         *        The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder millisUntilNextRefreshable(Long millisUntilNextRefreshable);
    }

    static final class BuilderImpl implements Builder {
        private String checkId;

        private String status;

        private Long millisUntilNextRefreshable;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckRefreshStatus model) {
            checkId(model.checkId);
            status(model.status);
            millisUntilNextRefreshable(model.millisUntilNextRefreshable);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getMillisUntilNextRefreshable() {
            return millisUntilNextRefreshable;
        }

        @Override
        public final Builder millisUntilNextRefreshable(Long millisUntilNextRefreshable) {
            this.millisUntilNextRefreshable = millisUntilNextRefreshable;
            return this;
        }

        public final void setMillisUntilNextRefreshable(Long millisUntilNextRefreshable) {
            this.millisUntilNextRefreshable = millisUntilNextRefreshable;
        }

        @Override
        public TrustedAdvisorCheckRefreshStatus build() {
            return new TrustedAdvisorCheckRefreshStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
