/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddAttachmentsToSetRequest extends SupportRequest implements
        ToCopyableBuilder<AddAttachmentsToSetRequest.Builder, AddAttachmentsToSetRequest> {
    private static final SdkField<String> ATTACHMENT_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentSetId").getter(getter(AddAttachmentsToSetRequest::attachmentSetId))
            .setter(setter(Builder::attachmentSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentSetId").build()).build();

    private static final SdkField<List<Attachment>> ATTACHMENTS_FIELD = SdkField
            .<List<Attachment>> builder(MarshallingType.LIST)
            .memberName("attachments")
            .getter(getter(AddAttachmentsToSetRequest::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_SET_ID_FIELD,
            ATTACHMENTS_FIELD));

    private final String attachmentSetId;

    private final List<Attachment> attachments;

    private AddAttachmentsToSetRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentSetId = builder.attachmentSetId;
        this.attachments = builder.attachments;
    }

    /**
     * <p>
     * The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is
     * created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the
     * attachments are added to the specified set, if it exists.
     * </p>
     * 
     * @return The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set
     *         is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is
     *         specified, the attachments are added to the specified set, if it exists.
     */
    public final String attachmentSetId() {
        return attachmentSetId;
    }

    /**
     * Returns true if the Attachments property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB
     * per attachment.
     * </p>
     * <p>
     * In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the
     * attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>,
     * which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the
     * attachment, such as <code>troubleshoot-screenshot.png</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more attachments to add to the set. You can add up to three attachments per set. The size limit is
     *         5 MB per attachment.</p>
     *         <p>
     *         In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the
     *         attachment file. In the previous request syntax, the value for <code>data</code> appear as
     *         <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code>
     *         is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.
     */
    public final List<Attachment> attachments() {
        return attachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentSetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAttachmentsToSetRequest)) {
            return false;
        }
        AddAttachmentsToSetRequest other = (AddAttachmentsToSetRequest) obj;
        return Objects.equals(attachmentSetId(), other.attachmentSetId()) && hasAttachments() == other.hasAttachments()
                && Objects.equals(attachments(), other.attachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddAttachmentsToSetRequest").add("AttachmentSetId", attachmentSetId())
                .add("Attachments", hasAttachments() ? attachments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentSetId":
            return Optional.ofNullable(clazz.cast(attachmentSetId()));
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddAttachmentsToSetRequest, T> g) {
        return obj -> g.apply((AddAttachmentsToSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddAttachmentsToSetRequest> {
        /**
         * <p>
         * The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is
         * created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified,
         * the attachments are added to the specified set, if it exists.
         * </p>
         * 
         * @param attachmentSetId
         *        The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment
         *        set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code>
         *        is specified, the attachments are added to the specified set, if it exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSetId(String attachmentSetId);

        /**
         * <p>
         * One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5
         * MB per attachment.
         * </p>
         * <p>
         * In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the
         * attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>,
         * which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the
         * attachment, such as <code>troubleshoot-screenshot.png</code>.
         * </p>
         * 
         * @param attachments
         *        One or more attachments to add to the set. You can add up to three attachments per set. The size limit
         *        is 5 MB per attachment.</p>
         *        <p>
         *        In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of
         *        the attachment file. In the previous request syntax, the value for <code>data</code> appear as
         *        <code>blob</code>, which is represented as a base64-encoded string. The value for
         *        <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<Attachment> attachments);

        /**
         * <p>
         * One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5
         * MB per attachment.
         * </p>
         * <p>
         * In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the
         * attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>,
         * which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the
         * attachment, such as <code>troubleshoot-screenshot.png</code>.
         * </p>
         * 
         * @param attachments
         *        One or more attachments to add to the set. You can add up to three attachments per set. The size limit
         *        is 5 MB per attachment.</p>
         *        <p>
         *        In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of
         *        the attachment file. In the previous request syntax, the value for <code>data</code> appear as
         *        <code>blob</code>, which is represented as a base64-encoded string. The value for
         *        <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Attachment... attachments);

        /**
         * <p>
         * One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5
         * MB per attachment.
         * </p>
         * <p>
         * In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the
         * attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>,
         * which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the
         * attachment, such as <code>troubleshoot-screenshot.png</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attachment>.Builder} avoiding the need to
         * create one manually via {@link List<Attachment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attachment>.Builder#build()} is called immediately and its
         * result is passed to {@link #attachments(List<Attachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link List<Attachment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(List<Attachment>)
         */
        Builder attachments(Consumer<Attachment.Builder>... attachments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private String attachmentSetId;

        private List<Attachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddAttachmentsToSetRequest model) {
            super(model);
            attachmentSetId(model.attachmentSetId);
            attachments(model.attachments);
        }

        public final String getAttachmentSetId() {
            return attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        public final List<Attachment.Builder> getAttachments() {
            List<Attachment.Builder> result = AttachmentsCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<Attachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> Attachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentsCopier.copyFromBuilder(attachments);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddAttachmentsToSetRequest build() {
            return new AddAttachmentsToSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
