/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of Amazon Web Services services returned by the <a>DescribeServices</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServicesResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeServicesResponse.Builder, DescribeServicesResponse> {
    private static final SdkField<List<Service>> SERVICES_FIELD = SdkField
            .<List<Service>> builder(MarshallingType.LIST)
            .memberName("services")
            .getter(getter(DescribeServicesResponse::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Service> builder(MarshallingType.SDK_POJO)
                                            .constructor(Service::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD));

    private final List<Service> services;

    private DescribeServicesResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON-formatted list of Amazon Web Services services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return A JSON-formatted list of Amazon Web Services services.
     */
    public final List<Service> services() {
        return services;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesResponse)) {
            return false;
        }
        DescribeServicesResponse other = (DescribeServicesResponse) obj;
        return hasServices() == other.hasServices() && Objects.equals(services(), other.services());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServicesResponse").add("Services", hasServices() ? services() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "services":
            return Optional.ofNullable(clazz.cast(services()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServicesResponse, T> g) {
        return obj -> g.apply((DescribeServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServicesResponse> {
        /**
         * <p>
         * A JSON-formatted list of Amazon Web Services services.
         * </p>
         * 
         * @param services
         *        A JSON-formatted list of Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<Service> services);

        /**
         * <p>
         * A JSON-formatted list of Amazon Web Services services.
         * </p>
         * 
         * @param services
         *        A JSON-formatted list of Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Service... services);

        /**
         * <p>
         * A JSON-formatted list of Amazon Web Services services.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Service>.Builder} avoiding the need to
         * create one manually via {@link List<Service>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Service>.Builder#build()} is called immediately and its
         * result is passed to {@link #services(List<Service>)}.
         * 
         * @param services
         *        a consumer that will call methods on {@link List<Service>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(List<Service>)
         */
        Builder services(Consumer<Service.Builder>... services);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<Service> services = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesResponse model) {
            super(model);
            services(model.services);
        }

        public final List<Service.Builder> getServices() {
            List<Service.Builder> result = ServiceListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServiceListCopier.copyFromBuilder(services);
        }

        @Override
        @Transient
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder services(Service... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder services(Consumer<Service.Builder>... services) {
            services(Stream.of(services).map(c -> Service.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeServicesResponse build() {
            return new DescribeServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
