/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The results of a Trusted Advisor check returned by <a>DescribeTrustedAdvisorCheckResult</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorCheckResult implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustedAdvisorCheckResult.Builder, TrustedAdvisorCheckResult> {
    private static final SdkField<String> CHECK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkId").getter(getter(TrustedAdvisorCheckResult::checkId)).setter(setter(Builder::checkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()).build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestamp").getter(getter(TrustedAdvisorCheckResult::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TrustedAdvisorCheckResult::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<TrustedAdvisorResourcesSummary> RESOURCES_SUMMARY_FIELD = SdkField
            .<TrustedAdvisorResourcesSummary> builder(MarshallingType.SDK_POJO).memberName("resourcesSummary")
            .getter(getter(TrustedAdvisorCheckResult::resourcesSummary)).setter(setter(Builder::resourcesSummary))
            .constructor(TrustedAdvisorResourcesSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesSummary").build()).build();

    private static final SdkField<TrustedAdvisorCategorySpecificSummary> CATEGORY_SPECIFIC_SUMMARY_FIELD = SdkField
            .<TrustedAdvisorCategorySpecificSummary> builder(MarshallingType.SDK_POJO).memberName("categorySpecificSummary")
            .getter(getter(TrustedAdvisorCheckResult::categorySpecificSummary)).setter(setter(Builder::categorySpecificSummary))
            .constructor(TrustedAdvisorCategorySpecificSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categorySpecificSummary").build())
            .build();

    private static final SdkField<List<TrustedAdvisorResourceDetail>> FLAGGED_RESOURCES_FIELD = SdkField
            .<List<TrustedAdvisorResourceDetail>> builder(MarshallingType.LIST)
            .memberName("flaggedResources")
            .getter(getter(TrustedAdvisorCheckResult::flaggedResources))
            .setter(setter(Builder::flaggedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flaggedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrustedAdvisorResourceDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrustedAdvisorResourceDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_ID_FIELD,
            TIMESTAMP_FIELD, STATUS_FIELD, RESOURCES_SUMMARY_FIELD, CATEGORY_SPECIFIC_SUMMARY_FIELD, FLAGGED_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String checkId;

    private final String timestamp;

    private final String status;

    private final TrustedAdvisorResourcesSummary resourcesSummary;

    private final TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

    private final List<TrustedAdvisorResourceDetail> flaggedResources;

    private TrustedAdvisorCheckResult(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.resourcesSummary = builder.resourcesSummary;
        this.categorySpecificSummary = builder.categorySpecificSummary;
        this.flaggedResources = builder.flaggedResources;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public final String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The time of the last refresh of the check.
     * </p>
     * 
     * @return The time of the last refresh of the check.
     */
    public final String timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     * </p>
     * 
     * @return The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     */
    public final String status() {
        return status;
    }

    /**
     * Returns the value of the ResourcesSummary property for this object.
     * 
     * @return The value of the ResourcesSummary property for this object.
     */
    public final TrustedAdvisorResourcesSummary resourcesSummary() {
        return resourcesSummary;
    }

    /**
     * <p>
     * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
     * currently supported.
     * </p>
     * 
     * @return Summary information that relates to the category of the check. Cost Optimizing is the only category that
     *         is currently supported.
     */
    public final TrustedAdvisorCategorySpecificSummary categorySpecificSummary() {
        return categorySpecificSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the FlaggedResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFlaggedResources() {
        return flaggedResources != null && !(flaggedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details about each resource listed in the check result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlaggedResources} method.
     * </p>
     * 
     * @return The details about each resource listed in the check result.
     */
    public final List<TrustedAdvisorResourceDetail> flaggedResources() {
        return flaggedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkId());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(categorySpecificSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasFlaggedResources() ? flaggedResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckResult)) {
            return false;
        }
        TrustedAdvisorCheckResult other = (TrustedAdvisorCheckResult) obj;
        return Objects.equals(checkId(), other.checkId()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(status(), other.status()) && Objects.equals(resourcesSummary(), other.resourcesSummary())
                && Objects.equals(categorySpecificSummary(), other.categorySpecificSummary())
                && hasFlaggedResources() == other.hasFlaggedResources()
                && Objects.equals(flaggedResources(), other.flaggedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustedAdvisorCheckResult").add("CheckId", checkId()).add("Timestamp", timestamp())
                .add("Status", status()).add("ResourcesSummary", resourcesSummary())
                .add("CategorySpecificSummary", categorySpecificSummary())
                .add("FlaggedResources", hasFlaggedResources() ? flaggedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkId":
            return Optional.ofNullable(clazz.cast(checkId()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "resourcesSummary":
            return Optional.ofNullable(clazz.cast(resourcesSummary()));
        case "categorySpecificSummary":
            return Optional.ofNullable(clazz.cast(categorySpecificSummary()));
        case "flaggedResources":
            return Optional.ofNullable(clazz.cast(flaggedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorCheckResult, T> g) {
        return obj -> g.apply((TrustedAdvisorCheckResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustedAdvisorCheckResult> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The time of the last refresh of the check.
         * </p>
         * 
         * @param timestamp
         *        The time of the last refresh of the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);

        /**
         * <p>
         * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * </p>
         * 
         * @param status
         *        The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * Sets the value of the ResourcesSummary property for this object.
         *
         * @param resourcesSummary
         *        The new value for the ResourcesSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary);

        /**
         * Sets the value of the ResourcesSummary property for this object.
         *
         * This is a convenience that creates an instance of the {@link TrustedAdvisorResourcesSummary.Builder} avoiding
         * the need to create one manually via {@link TrustedAdvisorResourcesSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedAdvisorResourcesSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #resourcesSummary(TrustedAdvisorResourcesSummary)}.
         * 
         * @param resourcesSummary
         *        a consumer that will call methods on {@link TrustedAdvisorResourcesSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesSummary(TrustedAdvisorResourcesSummary)
         */
        default Builder resourcesSummary(Consumer<TrustedAdvisorResourcesSummary.Builder> resourcesSummary) {
            return resourcesSummary(TrustedAdvisorResourcesSummary.builder().applyMutation(resourcesSummary).build());
        }

        /**
         * <p>
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
         * currently supported.
         * </p>
         * 
         * @param categorySpecificSummary
         *        Summary information that relates to the category of the check. Cost Optimizing is the only category
         *        that is currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary);

        /**
         * <p>
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
         * currently supported.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedAdvisorCategorySpecificSummary.Builder}
         * avoiding the need to create one manually via {@link TrustedAdvisorCategorySpecificSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedAdvisorCategorySpecificSummary.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #categorySpecificSummary(TrustedAdvisorCategorySpecificSummary)}.
         * 
         * @param categorySpecificSummary
         *        a consumer that will call methods on {@link TrustedAdvisorCategorySpecificSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categorySpecificSummary(TrustedAdvisorCategorySpecificSummary)
         */
        default Builder categorySpecificSummary(Consumer<TrustedAdvisorCategorySpecificSummary.Builder> categorySpecificSummary) {
            return categorySpecificSummary(TrustedAdvisorCategorySpecificSummary.builder().applyMutation(categorySpecificSummary)
                    .build());
        }

        /**
         * <p>
         * The details about each resource listed in the check result.
         * </p>
         * 
         * @param flaggedResources
         *        The details about each resource listed in the check result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flaggedResources(Collection<TrustedAdvisorResourceDetail> flaggedResources);

        /**
         * <p>
         * The details about each resource listed in the check result.
         * </p>
         * 
         * @param flaggedResources
         *        The details about each resource listed in the check result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flaggedResources(TrustedAdvisorResourceDetail... flaggedResources);

        /**
         * <p>
         * The details about each resource listed in the check result.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrustedAdvisorResourceDetail>.Builder}
         * avoiding the need to create one manually via {@link List<TrustedAdvisorResourceDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrustedAdvisorResourceDetail>.Builder#build()} is called
         * immediately and its result is passed to {@link #flaggedResources(List<TrustedAdvisorResourceDetail>)}.
         * 
         * @param flaggedResources
         *        a consumer that will call methods on {@link List<TrustedAdvisorResourceDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flaggedResources(List<TrustedAdvisorResourceDetail>)
         */
        Builder flaggedResources(Consumer<TrustedAdvisorResourceDetail.Builder>... flaggedResources);
    }

    static final class BuilderImpl implements Builder {
        private String checkId;

        private String timestamp;

        private String status;

        private TrustedAdvisorResourcesSummary resourcesSummary;

        private TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

        private List<TrustedAdvisorResourceDetail> flaggedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckResult model) {
            checkId(model.checkId);
            timestamp(model.timestamp);
            status(model.status);
            resourcesSummary(model.resourcesSummary);
            categorySpecificSummary(model.categorySpecificSummary);
            flaggedResources(model.flaggedResources);
        }

        public final String getCheckId() {
            return checkId;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @Override
        @Transient
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final TrustedAdvisorResourcesSummary.Builder getResourcesSummary() {
            return resourcesSummary != null ? resourcesSummary.toBuilder() : null;
        }

        public final void setResourcesSummary(TrustedAdvisorResourcesSummary.BuilderImpl resourcesSummary) {
            this.resourcesSummary = resourcesSummary != null ? resourcesSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary) {
            this.resourcesSummary = resourcesSummary;
            return this;
        }

        public final TrustedAdvisorCategorySpecificSummary.Builder getCategorySpecificSummary() {
            return categorySpecificSummary != null ? categorySpecificSummary.toBuilder() : null;
        }

        public final void setCategorySpecificSummary(TrustedAdvisorCategorySpecificSummary.BuilderImpl categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary != null ? categorySpecificSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
            return this;
        }

        public final List<TrustedAdvisorResourceDetail.Builder> getFlaggedResources() {
            List<TrustedAdvisorResourceDetail.Builder> result = TrustedAdvisorResourceDetailListCopier
                    .copyToBuilder(this.flaggedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlaggedResources(Collection<TrustedAdvisorResourceDetail.BuilderImpl> flaggedResources) {
            this.flaggedResources = TrustedAdvisorResourceDetailListCopier.copyFromBuilder(flaggedResources);
        }

        @Override
        @Transient
        public final Builder flaggedResources(Collection<TrustedAdvisorResourceDetail> flaggedResources) {
            this.flaggedResources = TrustedAdvisorResourceDetailListCopier.copy(flaggedResources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder flaggedResources(TrustedAdvisorResourceDetail... flaggedResources) {
            flaggedResources(Arrays.asList(flaggedResources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder flaggedResources(Consumer<TrustedAdvisorResourceDetail.Builder>... flaggedResources) {
            flaggedResources(Stream.of(flaggedResources)
                    .map(c -> TrustedAdvisorResourceDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TrustedAdvisorCheckResult build() {
            return new TrustedAdvisorCheckResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
