/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the Trusted Advisor check returned by the <a>DescribeTrustedAdvisorCheckResult</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustedAdvisorCheckResultResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckResultResponse.Builder, DescribeTrustedAdvisorCheckResultResponse> {
    private static final SdkField<TrustedAdvisorCheckResult> RESULT_FIELD = SdkField
            .<TrustedAdvisorCheckResult> builder(MarshallingType.SDK_POJO).memberName("result")
            .getter(getter(DescribeTrustedAdvisorCheckResultResponse::result)).setter(setter(Builder::result))
            .constructor(TrustedAdvisorCheckResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD));

    private final TrustedAdvisorCheckResult result;

    private DescribeTrustedAdvisorCheckResultResponse(BuilderImpl builder) {
        super(builder);
        this.result = builder.result;
    }

    /**
     * <p>
     * The detailed results of the Trusted Advisor check.
     * </p>
     * 
     * @return The detailed results of the Trusted Advisor check.
     */
    public final TrustedAdvisorCheckResult result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckResultResponse)) {
            return false;
        }
        DescribeTrustedAdvisorCheckResultResponse other = (DescribeTrustedAdvisorCheckResultResponse) obj;
        return Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrustedAdvisorCheckResultResponse").add("Result", result()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorCheckResultResponse, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorCheckResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrustedAdvisorCheckResultResponse> {
        /**
         * <p>
         * The detailed results of the Trusted Advisor check.
         * </p>
         * 
         * @param result
         *        The detailed results of the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(TrustedAdvisorCheckResult result);

        /**
         * <p>
         * The detailed results of the Trusted Advisor check.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustedAdvisorCheckResult.Builder}
         * avoiding the need to create one manually via {@link TrustedAdvisorCheckResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedAdvisorCheckResult.Builder#build()} is called immediately
         * and its result is passed to {@link #result(TrustedAdvisorCheckResult)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link TrustedAdvisorCheckResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(TrustedAdvisorCheckResult)
         */
        default Builder result(Consumer<TrustedAdvisorCheckResult.Builder> result) {
            return result(TrustedAdvisorCheckResult.builder().applyMutation(result).build());
        }
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private TrustedAdvisorCheckResult result;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckResultResponse model) {
            super(model);
            result(model.result);
        }

        public final TrustedAdvisorCheckResult.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        public final void setResult(TrustedAdvisorCheckResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        @Transient
        public final Builder result(TrustedAdvisorCheckResult result) {
            this.result = result;
            return this;
        }

        @Override
        public DescribeTrustedAdvisorCheckResultResponse build() {
            return new DescribeTrustedAdvisorCheckResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
