/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of severity levels returned by the <a>DescribeSeverityLevels</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSeverityLevelsResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeSeverityLevelsResponse.Builder, DescribeSeverityLevelsResponse> {
    private static final SdkField<List<SeverityLevel>> SEVERITY_LEVELS_FIELD = SdkField
            .<List<SeverityLevel>> builder(MarshallingType.LIST)
            .memberName("severityLevels")
            .getter(getter(DescribeSeverityLevelsResponse::severityLevels))
            .setter(setter(Builder::severityLevels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityLevels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SeverityLevel> builder(MarshallingType.SDK_POJO)
                                            .constructor(SeverityLevel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITY_LEVELS_FIELD));

    private final List<SeverityLevel> severityLevels;

    private DescribeSeverityLevelsResponse(BuilderImpl builder) {
        super(builder);
        this.severityLevels = builder.severityLevels;
    }

    /**
     * For responses, this returns true if the service returned a value for the SeverityLevels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSeverityLevels() {
        return severityLevels != null && !(severityLevels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available severity levels for the support case. Available severity levels are defined by your service level
     * agreement with Amazon Web Services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeverityLevels} method.
     * </p>
     * 
     * @return The available severity levels for the support case. Available severity levels are defined by your service
     *         level agreement with Amazon Web Services.
     */
    public final List<SeverityLevel> severityLevels() {
        return severityLevels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSeverityLevels() ? severityLevels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSeverityLevelsResponse)) {
            return false;
        }
        DescribeSeverityLevelsResponse other = (DescribeSeverityLevelsResponse) obj;
        return hasSeverityLevels() == other.hasSeverityLevels() && Objects.equals(severityLevels(), other.severityLevels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSeverityLevelsResponse")
                .add("SeverityLevels", hasSeverityLevels() ? severityLevels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "severityLevels":
            return Optional.ofNullable(clazz.cast(severityLevels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSeverityLevelsResponse, T> g) {
        return obj -> g.apply((DescribeSeverityLevelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSeverityLevelsResponse> {
        /**
         * <p>
         * The available severity levels for the support case. Available severity levels are defined by your service
         * level agreement with Amazon Web Services.
         * </p>
         * 
         * @param severityLevels
         *        The available severity levels for the support case. Available severity levels are defined by your
         *        service level agreement with Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLevels(Collection<SeverityLevel> severityLevels);

        /**
         * <p>
         * The available severity levels for the support case. Available severity levels are defined by your service
         * level agreement with Amazon Web Services.
         * </p>
         * 
         * @param severityLevels
         *        The available severity levels for the support case. Available severity levels are defined by your
         *        service level agreement with Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLevels(SeverityLevel... severityLevels);

        /**
         * <p>
         * The available severity levels for the support case. Available severity levels are defined by your service
         * level agreement with Amazon Web Services.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SeverityLevel>.Builder} avoiding the
         * need to create one manually via {@link List<SeverityLevel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SeverityLevel>.Builder#build()} is called immediately and
         * its result is passed to {@link #severityLevels(List<SeverityLevel>)}.
         * 
         * @param severityLevels
         *        a consumer that will call methods on {@link List<SeverityLevel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityLevels(List<SeverityLevel>)
         */
        Builder severityLevels(Consumer<SeverityLevel.Builder>... severityLevels);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<SeverityLevel> severityLevels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSeverityLevelsResponse model) {
            super(model);
            severityLevels(model.severityLevels);
        }

        public final List<SeverityLevel.Builder> getSeverityLevels() {
            List<SeverityLevel.Builder> result = SeverityLevelsListCopier.copyToBuilder(this.severityLevels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeverityLevels(Collection<SeverityLevel.BuilderImpl> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copyFromBuilder(severityLevels);
        }

        @Override
        public final Builder severityLevels(Collection<SeverityLevel> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copy(severityLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(SeverityLevel... severityLevels) {
            severityLevels(Arrays.asList(severityLevels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(Consumer<SeverityLevel.Builder>... severityLevels) {
            severityLevels(Stream.of(severityLevels).map(c -> SeverityLevel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSeverityLevelsResponse build() {
            return new DescribeSeverityLevelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
