/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A communication associated with a support case. The communication consists of the case ID, the message body,
 * attachment information, the submitter of the communication, and the date and time of the communication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Communication implements SdkPojo, Serializable, ToCopyableBuilder<Communication.Builder, Communication> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(Communication::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseId").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(Communication::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<String> SUBMITTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("submittedBy").getter(getter(Communication::submittedBy)).setter(setter(Builder::submittedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedBy").build()).build();

    private static final SdkField<String> TIME_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeCreated").getter(getter(Communication::timeCreated)).setter(setter(Builder::timeCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeCreated").build()).build();

    private static final SdkField<List<AttachmentDetails>> ATTACHMENT_SET_FIELD = SdkField
            .<List<AttachmentDetails>> builder(MarshallingType.LIST)
            .memberName("attachmentSet")
            .getter(getter(Communication::attachmentSet))
            .setter(setter(Builder::attachmentSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, BODY_FIELD,
            SUBMITTED_BY_FIELD, TIME_CREATED_FIELD, ATTACHMENT_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String caseId;

    private final String body;

    private final String submittedBy;

    private final String timeCreated;

    private final List<AttachmentDetails> attachmentSet;

    private Communication(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.body = builder.body;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.attachmentSet = builder.attachmentSet;
    }

    /**
     * <p>
     * The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown
     * in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     * </p>
     * 
     * @return The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
     *         shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * <p>
     * The text of the communication between the customer and Amazon Web Services Support.
     * </p>
     * 
     * @return The text of the communication between the customer and Amazon Web Services Support.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * The identity of the account that submitted, or responded to, the support case. Customer entries include the role
     * or IAM user as well as the email address. For example,
     * "AdminRole (Role) &lt;janedoe@example.com&gt;. Entries from the Amazon Web Services Support team display "Amazon
     * Web Services," and don't show an email address.
     * </p>
     * 
     * @return The identity of the account that submitted, or responded to, the support case. Customer entries include
     *         the role or IAM user as well as the email address. For example,
     *         "AdminRole (Role) &lt;janedoe@example.com&gt;. Entries from the Amazon Web Services Support team display "
     *         Amazon Web Services," and don't show an email address.
     */
    public final String submittedBy() {
        return submittedBy;
    }

    /**
     * <p>
     * The time the communication was created.
     * </p>
     * 
     * @return The time the communication was created.
     */
    public final String timeCreated() {
        return timeCreated;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachmentSet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachmentSet() {
        return attachmentSet != null && !(attachmentSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the attachments to the case communication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachmentSet} method.
     * </p>
     * 
     * @return Information about the attachments to the case communication.
     */
    public final List<AttachmentDetails> attachmentSet() {
        return attachmentSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(submittedBy());
        hashCode = 31 * hashCode + Objects.hashCode(timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachmentSet() ? attachmentSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Communication)) {
            return false;
        }
        Communication other = (Communication) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(body(), other.body())
                && Objects.equals(submittedBy(), other.submittedBy()) && Objects.equals(timeCreated(), other.timeCreated())
                && hasAttachmentSet() == other.hasAttachmentSet() && Objects.equals(attachmentSet(), other.attachmentSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Communication").add("CaseId", caseId()).add("Body", body()).add("SubmittedBy", submittedBy())
                .add("TimeCreated", timeCreated()).add("AttachmentSet", hasAttachmentSet() ? attachmentSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "submittedBy":
            return Optional.ofNullable(clazz.cast(submittedBy()));
        case "timeCreated":
            return Optional.ofNullable(clazz.cast(timeCreated()));
        case "attachmentSet":
            return Optional.ofNullable(clazz.cast(attachmentSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Communication, T> g) {
        return obj -> g.apply((Communication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Communication> {
        /**
         * <p>
         * The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
         * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * </p>
         * 
         * @param caseId
         *        The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted
         *        as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * The text of the communication between the customer and Amazon Web Services Support.
         * </p>
         * 
         * @param body
         *        The text of the communication between the customer and Amazon Web Services Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The identity of the account that submitted, or responded to, the support case. Customer entries include the
         * role or IAM user as well as the email address. For example,
         * "AdminRole (Role) &lt;janedoe@example.com&gt;. Entries from the Amazon Web Services Support team display "
         * Amazon Web Services," and don't show an email address.
         * </p>
         * 
         * @param submittedBy
         *        The identity of the account that submitted, or responded to, the support case. Customer entries
         *        include the role or IAM user as well as the email address. For example,
         *        "AdminRole (Role) &lt;janedoe@example.com&gt;. Entries from the Amazon Web Services Support team display "
         *        Amazon Web Services," and don't show an email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedBy(String submittedBy);

        /**
         * <p>
         * The time the communication was created.
         * </p>
         * 
         * @param timeCreated
         *        The time the communication was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCreated(String timeCreated);

        /**
         * <p>
         * Information about the attachments to the case communication.
         * </p>
         * 
         * @param attachmentSet
         *        Information about the attachments to the case communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSet(Collection<AttachmentDetails> attachmentSet);

        /**
         * <p>
         * Information about the attachments to the case communication.
         * </p>
         * 
         * @param attachmentSet
         *        Information about the attachments to the case communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSet(AttachmentDetails... attachmentSet);

        /**
         * <p>
         * Information about the attachments to the case communication.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AttachmentDetails>.Builder} avoiding
         * the need to create one manually via {@link List<AttachmentDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachmentDetails>.Builder#build()} is called immediately
         * and its result is passed to {@link #attachmentSet(List<AttachmentDetails>)}.
         * 
         * @param attachmentSet
         *        a consumer that will call methods on {@link List<AttachmentDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentSet(List<AttachmentDetails>)
         */
        Builder attachmentSet(Consumer<AttachmentDetails.Builder>... attachmentSet);
    }

    static final class BuilderImpl implements Builder {
        private String caseId;

        private String body;

        private String submittedBy;

        private String timeCreated;

        private List<AttachmentDetails> attachmentSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Communication model) {
            caseId(model.caseId);
            body(model.body);
            submittedBy(model.submittedBy);
            timeCreated(model.timeCreated);
            attachmentSet(model.attachmentSet);
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getSubmittedBy() {
            return submittedBy;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final String getTimeCreated() {
            return timeCreated;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final List<AttachmentDetails.Builder> getAttachmentSet() {
            List<AttachmentDetails.Builder> result = AttachmentSetCopier.copyToBuilder(this.attachmentSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachmentSet(Collection<AttachmentDetails.BuilderImpl> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copyFromBuilder(attachmentSet);
        }

        @Override
        public final Builder attachmentSet(Collection<AttachmentDetails> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copy(attachmentSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentSet(AttachmentDetails... attachmentSet) {
            attachmentSet(Arrays.asList(attachmentSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentSet(Consumer<AttachmentDetails.Builder>... attachmentSet) {
            attachmentSet(Stream.of(attachmentSet).map(c -> AttachmentDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Communication build() {
            return new Communication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
