/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCasesRequest extends SupportRequest implements
        ToCopyableBuilder<DescribeCasesRequest.Builder, DescribeCasesRequest> {
    private static final SdkField<List<String>> CASE_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("caseIdList")
            .getter(getter(DescribeCasesRequest::caseIdList))
            .setter(setter(Builder::caseIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DISPLAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayId").getter(getter(DescribeCasesRequest::displayId)).setter(setter(Builder::displayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayId").build()).build();

    private static final SdkField<String> AFTER_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterTime").getter(getter(DescribeCasesRequest::afterTime)).setter(setter(Builder::afterTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterTime").build()).build();

    private static final SdkField<String> BEFORE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("beforeTime").getter(getter(DescribeCasesRequest::beforeTime)).setter(setter(Builder::beforeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeTime").build()).build();

    private static final SdkField<Boolean> INCLUDE_RESOLVED_CASES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeResolvedCases").getter(getter(DescribeCasesRequest::includeResolvedCases))
            .setter(setter(Builder::includeResolvedCases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeResolvedCases").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeCasesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeCasesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(DescribeCasesRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<Boolean> INCLUDE_COMMUNICATIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeCommunications").getter(getter(DescribeCasesRequest::includeCommunications))
            .setter(setter(Builder::includeCommunications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeCommunications").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_LIST_FIELD,
            DISPLAY_ID_FIELD, AFTER_TIME_FIELD, BEFORE_TIME_FIELD, INCLUDE_RESOLVED_CASES_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, LANGUAGE_FIELD, INCLUDE_COMMUNICATIONS_FIELD));

    private final List<String> caseIdList;

    private final String displayId;

    private final String afterTime;

    private final String beforeTime;

    private final Boolean includeResolvedCases;

    private final String nextToken;

    private final Integer maxResults;

    private final String language;

    private final Boolean includeCommunications;

    private DescribeCasesRequest(BuilderImpl builder) {
        super(builder);
        this.caseIdList = builder.caseIdList;
        this.displayId = builder.displayId;
        this.afterTime = builder.afterTime;
        this.beforeTime = builder.beforeTime;
        this.includeResolvedCases = builder.includeResolvedCases;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.language = builder.language;
        this.includeCommunications = builder.includeCommunications;
    }

    /**
     * For responses, this returns true if the service returned a value for the CaseIdList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCaseIdList() {
        return caseIdList != null && !(caseIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaseIdList} method.
     * </p>
     * 
     * @return A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
     */
    public final List<String> caseIdList() {
        return caseIdList;
    }

    /**
     * <p>
     * The ID displayed for a case in the AWS Support Center user interface.
     * </p>
     * 
     * @return The ID displayed for a case in the AWS Support Center user interface.
     */
    public final String displayId() {
        return displayId;
    }

    /**
     * <p>
     * The start date for a filtered date search on support case communications. Case communications are available for
     * 12 months after creation.
     * </p>
     * 
     * @return The start date for a filtered date search on support case communications. Case communications are
     *         available for 12 months after creation.
     */
    public final String afterTime() {
        return afterTime;
    }

    /**
     * <p>
     * The end date for a filtered date search on support case communications. Case communications are available for 12
     * months after creation.
     * </p>
     * 
     * @return The end date for a filtered date search on support case communications. Case communications are available
     *         for 12 months after creation.
     */
    public final String beforeTime() {
        return beforeTime;
    }

    /**
     * <p>
     * Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default,
     * resolved cases aren't included.
     * </p>
     * 
     * @return Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By
     *         default, resolved cases aren't included.
     */
    public final Boolean includeResolvedCases() {
        return includeResolvedCases;
    }

    /**
     * <p>
     * A resumption point for pagination.
     * </p>
     * 
     * @return A resumption point for pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return before paginating.
     * </p>
     * 
     * @return The maximum number of results to return before paginating.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * Specifies whether to include communications in the <code>DescribeCases</code> response. By default,
     * communications are included.
     * </p>
     * 
     * @return Specifies whether to include communications in the <code>DescribeCases</code> response. By default,
     *         communications are included.
     */
    public final Boolean includeCommunications() {
        return includeCommunications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCaseIdList() ? caseIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(displayId());
        hashCode = 31 * hashCode + Objects.hashCode(afterTime());
        hashCode = 31 * hashCode + Objects.hashCode(beforeTime());
        hashCode = 31 * hashCode + Objects.hashCode(includeResolvedCases());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(includeCommunications());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCasesRequest)) {
            return false;
        }
        DescribeCasesRequest other = (DescribeCasesRequest) obj;
        return hasCaseIdList() == other.hasCaseIdList() && Objects.equals(caseIdList(), other.caseIdList())
                && Objects.equals(displayId(), other.displayId()) && Objects.equals(afterTime(), other.afterTime())
                && Objects.equals(beforeTime(), other.beforeTime())
                && Objects.equals(includeResolvedCases(), other.includeResolvedCases())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(language(), other.language())
                && Objects.equals(includeCommunications(), other.includeCommunications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCasesRequest").add("CaseIdList", hasCaseIdList() ? caseIdList() : null)
                .add("DisplayId", displayId()).add("AfterTime", afterTime()).add("BeforeTime", beforeTime())
                .add("IncludeResolvedCases", includeResolvedCases()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Language", language())
                .add("IncludeCommunications", includeCommunications()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseIdList":
            return Optional.ofNullable(clazz.cast(caseIdList()));
        case "displayId":
            return Optional.ofNullable(clazz.cast(displayId()));
        case "afterTime":
            return Optional.ofNullable(clazz.cast(afterTime()));
        case "beforeTime":
            return Optional.ofNullable(clazz.cast(beforeTime()));
        case "includeResolvedCases":
            return Optional.ofNullable(clazz.cast(includeResolvedCases()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "includeCommunications":
            return Optional.ofNullable(clazz.cast(includeCommunications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCasesRequest, T> g) {
        return obj -> g.apply((DescribeCasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCasesRequest> {
        /**
         * <p>
         * A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
         * </p>
         * 
         * @param caseIdList
         *        A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseIdList(Collection<String> caseIdList);

        /**
         * <p>
         * A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
         * </p>
         * 
         * @param caseIdList
         *        A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseIdList(String... caseIdList);

        /**
         * <p>
         * The ID displayed for a case in the AWS Support Center user interface.
         * </p>
         * 
         * @param displayId
         *        The ID displayed for a case in the AWS Support Center user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayId(String displayId);

        /**
         * <p>
         * The start date for a filtered date search on support case communications. Case communications are available
         * for 12 months after creation.
         * </p>
         * 
         * @param afterTime
         *        The start date for a filtered date search on support case communications. Case communications are
         *        available for 12 months after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterTime(String afterTime);

        /**
         * <p>
         * The end date for a filtered date search on support case communications. Case communications are available for
         * 12 months after creation.
         * </p>
         * 
         * @param beforeTime
         *        The end date for a filtered date search on support case communications. Case communications are
         *        available for 12 months after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeTime(String beforeTime);

        /**
         * <p>
         * Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default,
         * resolved cases aren't included.
         * </p>
         * 
         * @param includeResolvedCases
         *        Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By
         *        default, resolved cases aren't included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeResolvedCases(Boolean includeResolvedCases);

        /**
         * <p>
         * A resumption point for pagination.
         * </p>
         * 
         * @param nextToken
         *        A resumption point for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return before paginating.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return before paginating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * Specifies whether to include communications in the <code>DescribeCases</code> response. By default,
         * communications are included.
         * </p>
         * 
         * @param includeCommunications
         *        Specifies whether to include communications in the <code>DescribeCases</code> response. By default,
         *        communications are included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCommunications(Boolean includeCommunications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private List<String> caseIdList = DefaultSdkAutoConstructList.getInstance();

        private String displayId;

        private String afterTime;

        private String beforeTime;

        private Boolean includeResolvedCases;

        private String nextToken;

        private Integer maxResults;

        private String language;

        private Boolean includeCommunications;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCasesRequest model) {
            super(model);
            caseIdList(model.caseIdList);
            displayId(model.displayId);
            afterTime(model.afterTime);
            beforeTime(model.beforeTime);
            includeResolvedCases(model.includeResolvedCases);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            language(model.language);
            includeCommunications(model.includeCommunications);
        }

        public final Collection<String> getCaseIdList() {
            if (caseIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return caseIdList;
        }

        public final void setCaseIdList(Collection<String> caseIdList) {
            this.caseIdList = CaseIdListCopier.copy(caseIdList);
        }

        @Override
        @Transient
        public final Builder caseIdList(Collection<String> caseIdList) {
            this.caseIdList = CaseIdListCopier.copy(caseIdList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder caseIdList(String... caseIdList) {
            caseIdList(Arrays.asList(caseIdList));
            return this;
        }

        public final String getDisplayId() {
            return displayId;
        }

        public final void setDisplayId(String displayId) {
            this.displayId = displayId;
        }

        @Override
        @Transient
        public final Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final String getAfterTime() {
            return afterTime;
        }

        public final void setAfterTime(String afterTime) {
            this.afterTime = afterTime;
        }

        @Override
        @Transient
        public final Builder afterTime(String afterTime) {
            this.afterTime = afterTime;
            return this;
        }

        public final String getBeforeTime() {
            return beforeTime;
        }

        public final void setBeforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
        }

        @Override
        @Transient
        public final Builder beforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
            return this;
        }

        public final Boolean getIncludeResolvedCases() {
            return includeResolvedCases;
        }

        public final void setIncludeResolvedCases(Boolean includeResolvedCases) {
            this.includeResolvedCases = includeResolvedCases;
        }

        @Override
        @Transient
        public final Builder includeResolvedCases(Boolean includeResolvedCases) {
            this.includeResolvedCases = includeResolvedCases;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        @Transient
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Boolean getIncludeCommunications() {
            return includeCommunications;
        }

        public final void setIncludeCommunications(Boolean includeCommunications) {
            this.includeCommunications = includeCommunications;
        }

        @Override
        @Transient
        public final Builder includeCommunications(Boolean includeCommunications) {
            this.includeCommunications = includeCommunications;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCasesRequest build() {
            return new DescribeCasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
