/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summaries of the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorCheckSummaries</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustedAdvisorCheckSummariesResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckSummariesResponse.Builder, DescribeTrustedAdvisorCheckSummariesResponse> {
    private static final SdkField<List<TrustedAdvisorCheckSummary>> SUMMARIES_FIELD = SdkField
            .<List<TrustedAdvisorCheckSummary>> builder(MarshallingType.LIST)
            .memberName("summaries")
            .getter(getter(DescribeTrustedAdvisorCheckSummariesResponse::summaries))
            .setter(setter(Builder::summaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrustedAdvisorCheckSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrustedAdvisorCheckSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD));

    private final List<TrustedAdvisorCheckSummary> summaries;

    private DescribeTrustedAdvisorCheckSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Summaries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSummaries() {
        return summaries != null && !(summaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary information for the requested Trusted Advisor checks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSummaries} method.
     * </p>
     * 
     * @return The summary information for the requested Trusted Advisor checks.
     */
    public final List<TrustedAdvisorCheckSummary> summaries() {
        return summaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaries() ? summaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckSummariesResponse)) {
            return false;
        }
        DescribeTrustedAdvisorCheckSummariesResponse other = (DescribeTrustedAdvisorCheckSummariesResponse) obj;
        return hasSummaries() == other.hasSummaries() && Objects.equals(summaries(), other.summaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrustedAdvisorCheckSummariesResponse")
                .add("Summaries", hasSummaries() ? summaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summaries":
            return Optional.ofNullable(clazz.cast(summaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorCheckSummariesResponse, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorCheckSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrustedAdvisorCheckSummariesResponse> {
        /**
         * <p>
         * The summary information for the requested Trusted Advisor checks.
         * </p>
         * 
         * @param summaries
         *        The summary information for the requested Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<TrustedAdvisorCheckSummary> summaries);

        /**
         * <p>
         * The summary information for the requested Trusted Advisor checks.
         * </p>
         * 
         * @param summaries
         *        The summary information for the requested Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(TrustedAdvisorCheckSummary... summaries);

        /**
         * <p>
         * The summary information for the requested Trusted Advisor checks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrustedAdvisorCheckSummary>.Builder}
         * avoiding the need to create one manually via {@link List<TrustedAdvisorCheckSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrustedAdvisorCheckSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #summaries(List<TrustedAdvisorCheckSummary>)}.
         * 
         * @param summaries
         *        a consumer that will call methods on {@link List<TrustedAdvisorCheckSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaries(List<TrustedAdvisorCheckSummary>)
         */
        Builder summaries(Consumer<TrustedAdvisorCheckSummary.Builder>... summaries);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<TrustedAdvisorCheckSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckSummariesResponse model) {
            super(model);
            summaries(model.summaries);
        }

        public final List<TrustedAdvisorCheckSummary.Builder> getSummaries() {
            List<TrustedAdvisorCheckSummary.Builder> result = TrustedAdvisorCheckSummaryListCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<TrustedAdvisorCheckSummary.BuilderImpl> summaries) {
            this.summaries = TrustedAdvisorCheckSummaryListCopier.copyFromBuilder(summaries);
        }

        @Override
        @Transient
        public final Builder summaries(Collection<TrustedAdvisorCheckSummary> summaries) {
            this.summaries = TrustedAdvisorCheckSummaryListCopier.copy(summaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaries(TrustedAdvisorCheckSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaries(Consumer<TrustedAdvisorCheckSummary.Builder>... summaries) {
            summaries(Stream.of(summaries).map(c -> TrustedAdvisorCheckSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTrustedAdvisorCheckSummariesResponse build() {
            return new DescribeTrustedAdvisorCheckSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
