/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the case returned by the <a>ResolveCase</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolveCaseResponse extends SupportResponse implements
        ToCopyableBuilder<ResolveCaseResponse.Builder, ResolveCaseResponse> {
    private static final SdkField<String> INITIAL_CASE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initialCaseStatus").getter(getter(ResolveCaseResponse::initialCaseStatus))
            .setter(setter(Builder::initialCaseStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialCaseStatus").build()).build();

    private static final SdkField<String> FINAL_CASE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("finalCaseStatus").getter(getter(ResolveCaseResponse::finalCaseStatus))
            .setter(setter(Builder::finalCaseStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalCaseStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_CASE_STATUS_FIELD,
            FINAL_CASE_STATUS_FIELD));

    private final String initialCaseStatus;

    private final String finalCaseStatus;

    private ResolveCaseResponse(BuilderImpl builder) {
        super(builder);
        this.initialCaseStatus = builder.initialCaseStatus;
        this.finalCaseStatus = builder.finalCaseStatus;
    }

    /**
     * <p>
     * The status of the case when the <a>ResolveCase</a> request was sent.
     * </p>
     * 
     * @return The status of the case when the <a>ResolveCase</a> request was sent.
     */
    public final String initialCaseStatus() {
        return initialCaseStatus;
    }

    /**
     * <p>
     * The status of the case after the <a>ResolveCase</a> request was processed.
     * </p>
     * 
     * @return The status of the case after the <a>ResolveCase</a> request was processed.
     */
    public final String finalCaseStatus() {
        return finalCaseStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(initialCaseStatus());
        hashCode = 31 * hashCode + Objects.hashCode(finalCaseStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveCaseResponse)) {
            return false;
        }
        ResolveCaseResponse other = (ResolveCaseResponse) obj;
        return Objects.equals(initialCaseStatus(), other.initialCaseStatus())
                && Objects.equals(finalCaseStatus(), other.finalCaseStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolveCaseResponse").add("InitialCaseStatus", initialCaseStatus())
                .add("FinalCaseStatus", finalCaseStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "initialCaseStatus":
            return Optional.ofNullable(clazz.cast(initialCaseStatus()));
        case "finalCaseStatus":
            return Optional.ofNullable(clazz.cast(finalCaseStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolveCaseResponse, T> g) {
        return obj -> g.apply((ResolveCaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo, CopyableBuilder<Builder, ResolveCaseResponse> {
        /**
         * <p>
         * The status of the case when the <a>ResolveCase</a> request was sent.
         * </p>
         * 
         * @param initialCaseStatus
         *        The status of the case when the <a>ResolveCase</a> request was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialCaseStatus(String initialCaseStatus);

        /**
         * <p>
         * The status of the case after the <a>ResolveCase</a> request was processed.
         * </p>
         * 
         * @param finalCaseStatus
         *        The status of the case after the <a>ResolveCase</a> request was processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalCaseStatus(String finalCaseStatus);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private String initialCaseStatus;

        private String finalCaseStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveCaseResponse model) {
            super(model);
            initialCaseStatus(model.initialCaseStatus);
            finalCaseStatus(model.finalCaseStatus);
        }

        public final String getInitialCaseStatus() {
            return initialCaseStatus;
        }

        public final void setInitialCaseStatus(String initialCaseStatus) {
            this.initialCaseStatus = initialCaseStatus;
        }

        @Override
        public final Builder initialCaseStatus(String initialCaseStatus) {
            this.initialCaseStatus = initialCaseStatus;
            return this;
        }

        public final String getFinalCaseStatus() {
            return finalCaseStatus;
        }

        public final void setFinalCaseStatus(String finalCaseStatus) {
            this.finalCaseStatus = finalCaseStatus;
        }

        @Override
        public final Builder finalCaseStatus(String finalCaseStatus) {
            this.finalCaseStatus = finalCaseStatus;
            return this;
        }

        @Override
        public ResolveCaseResponse build() {
            return new ResolveCaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
