/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The estimated cost savings that might be realized if the recommended operations are taken.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorCostOptimizingSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustedAdvisorCostOptimizingSummary.Builder, TrustedAdvisorCostOptimizingSummary> {
    private static final SdkField<Double> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedMonthlySavings").getter(getter(TrustedAdvisorCostOptimizingSummary::estimatedMonthlySavings))
            .setter(setter(Builder::estimatedMonthlySavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build())
            .build();

    private static final SdkField<Double> ESTIMATED_PERCENT_MONTHLY_SAVINGS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedPercentMonthlySavings")
            .getter(getter(TrustedAdvisorCostOptimizingSummary::estimatedPercentMonthlySavings))
            .setter(setter(Builder::estimatedPercentMonthlySavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedPercentMonthlySavings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_MONTHLY_SAVINGS_FIELD, ESTIMATED_PERCENT_MONTHLY_SAVINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double estimatedMonthlySavings;

    private final Double estimatedPercentMonthlySavings;

    private TrustedAdvisorCostOptimizingSummary(BuilderImpl builder) {
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.estimatedPercentMonthlySavings = builder.estimatedPercentMonthlySavings;
    }

    /**
     * <p>
     * The estimated monthly savings that might be realized if the recommended operations are taken.
     * </p>
     * 
     * @return The estimated monthly savings that might be realized if the recommended operations are taken.
     */
    public final Double estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    /**
     * <p>
     * The estimated percentage of savings that might be realized if the recommended operations are taken.
     * </p>
     * 
     * @return The estimated percentage of savings that might be realized if the recommended operations are taken.
     */
    public final Double estimatedPercentMonthlySavings() {
        return estimatedPercentMonthlySavings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedPercentMonthlySavings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCostOptimizingSummary)) {
            return false;
        }
        TrustedAdvisorCostOptimizingSummary other = (TrustedAdvisorCostOptimizingSummary) obj;
        return Objects.equals(estimatedMonthlySavings(), other.estimatedMonthlySavings())
                && Objects.equals(estimatedPercentMonthlySavings(), other.estimatedPercentMonthlySavings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustedAdvisorCostOptimizingSummary").add("EstimatedMonthlySavings", estimatedMonthlySavings())
                .add("EstimatedPercentMonthlySavings", estimatedPercentMonthlySavings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "estimatedMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavings()));
        case "estimatedPercentMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedPercentMonthlySavings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorCostOptimizingSummary, T> g) {
        return obj -> g.apply((TrustedAdvisorCostOptimizingSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustedAdvisorCostOptimizingSummary> {
        /**
         * <p>
         * The estimated monthly savings that might be realized if the recommended operations are taken.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        The estimated monthly savings that might be realized if the recommended operations are taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(Double estimatedMonthlySavings);

        /**
         * <p>
         * The estimated percentage of savings that might be realized if the recommended operations are taken.
         * </p>
         * 
         * @param estimatedPercentMonthlySavings
         *        The estimated percentage of savings that might be realized if the recommended operations are taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings);
    }

    static final class BuilderImpl implements Builder {
        private Double estimatedMonthlySavings;

        private Double estimatedPercentMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCostOptimizingSummary model) {
            estimatedMonthlySavings(model.estimatedMonthlySavings);
            estimatedPercentMonthlySavings(model.estimatedPercentMonthlySavings);
        }

        public final Double getEstimatedMonthlySavings() {
            return estimatedMonthlySavings;
        }

        public final void setEstimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final Double getEstimatedPercentMonthlySavings() {
            return estimatedPercentMonthlySavings;
        }

        public final void setEstimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
            this.estimatedPercentMonthlySavings = estimatedPercentMonthlySavings;
        }

        @Override
        public final Builder estimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
            this.estimatedPercentMonthlySavings = estimatedPercentMonthlySavings;
            return this;
        }

        @Override
        public TrustedAdvisorCostOptimizingSummary build() {
            return new TrustedAdvisorCostOptimizingSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
