/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.CcEmailAddressListCopier;
import software.amazon.awssdk.services.support.model.RecentCaseCommunications;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaseDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaseDetails> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseId").getter(CaseDetails.getter(CaseDetails::caseId)).setter(CaseDetails.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseId").build()}).build();
    private static final SdkField<String> DISPLAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayId").getter(CaseDetails.getter(CaseDetails::displayId)).setter(CaseDetails.setter(Builder::displayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayId").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subject").getter(CaseDetails.getter(CaseDetails::subject)).setter(CaseDetails.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CaseDetails.getter(CaseDetails::status)).setter(CaseDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(CaseDetails.getter(CaseDetails::serviceCode)).setter(CaseDetails.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final SdkField<String> CATEGORY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("categoryCode").getter(CaseDetails.getter(CaseDetails::categoryCode)).setter(CaseDetails.setter(Builder::categoryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoryCode").build()}).build();
    private static final SdkField<String> SEVERITY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severityCode").getter(CaseDetails.getter(CaseDetails::severityCode)).setter(CaseDetails.setter(Builder::severityCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCode").build()}).build();
    private static final SdkField<String> SUBMITTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("submittedBy").getter(CaseDetails.getter(CaseDetails::submittedBy)).setter(CaseDetails.setter(Builder::submittedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedBy").build()}).build();
    private static final SdkField<String> TIME_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeCreated").getter(CaseDetails.getter(CaseDetails::timeCreated)).setter(CaseDetails.setter(Builder::timeCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeCreated").build()}).build();
    private static final SdkField<RecentCaseCommunications> RECENT_COMMUNICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recentCommunications").getter(CaseDetails.getter(CaseDetails::recentCommunications)).setter(CaseDetails.setter(Builder::recentCommunications)).constructor(RecentCaseCommunications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recentCommunications").build()}).build();
    private static final SdkField<List<String>> CC_EMAIL_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ccEmailAddresses").getter(CaseDetails.getter(CaseDetails::ccEmailAddresses)).setter(CaseDetails.setter(Builder::ccEmailAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccEmailAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(CaseDetails.getter(CaseDetails::language)).setter(CaseDetails.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, DISPLAY_ID_FIELD, SUBJECT_FIELD, STATUS_FIELD, SERVICE_CODE_FIELD, CATEGORY_CODE_FIELD, SEVERITY_CODE_FIELD, SUBMITTED_BY_FIELD, TIME_CREATED_FIELD, RECENT_COMMUNICATIONS_FIELD, CC_EMAIL_ADDRESSES_FIELD, LANGUAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String caseId;
    private final String displayId;
    private final String subject;
    private final String status;
    private final String serviceCode;
    private final String categoryCode;
    private final String severityCode;
    private final String submittedBy;
    private final String timeCreated;
    private final RecentCaseCommunications recentCommunications;
    private final List<String> ccEmailAddresses;
    private final String language;

    private CaseDetails(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.displayId = builder.displayId;
        this.subject = builder.subject;
        this.status = builder.status;
        this.serviceCode = builder.serviceCode;
        this.categoryCode = builder.categoryCode;
        this.severityCode = builder.severityCode;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.recentCommunications = builder.recentCommunications;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
    }

    public final String caseId() {
        return this.caseId;
    }

    public final String displayId() {
        return this.displayId;
    }

    public final String subject() {
        return this.subject;
    }

    public final String status() {
        return this.status;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String categoryCode() {
        return this.categoryCode;
    }

    public final String severityCode() {
        return this.severityCode;
    }

    public final String submittedBy() {
        return this.submittedBy;
    }

    public final String timeCreated() {
        return this.timeCreated;
    }

    public final RecentCaseCommunications recentCommunications() {
        return this.recentCommunications;
    }

    public final boolean hasCcEmailAddresses() {
        return this.ccEmailAddresses != null && !(this.ccEmailAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> ccEmailAddresses() {
        return this.ccEmailAddresses;
    }

    public final String language() {
        return this.language;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.recentCommunications());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCcEmailAddresses() ? this.ccEmailAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseDetails)) {
            return false;
        }
        CaseDetails other = (CaseDetails)obj;
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.displayId(), other.displayId()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.categoryCode(), other.categoryCode()) && Objects.equals(this.severityCode(), other.severityCode()) && Objects.equals(this.submittedBy(), other.submittedBy()) && Objects.equals(this.timeCreated(), other.timeCreated()) && Objects.equals(this.recentCommunications(), other.recentCommunications()) && this.hasCcEmailAddresses() == other.hasCcEmailAddresses() && Objects.equals(this.ccEmailAddresses(), other.ccEmailAddresses()) && Objects.equals(this.language(), other.language());
    }

    public final String toString() {
        return ToString.builder((String)"CaseDetails").add("CaseId", (Object)this.caseId()).add("DisplayId", (Object)this.displayId()).add("Subject", (Object)this.subject()).add("Status", (Object)this.status()).add("ServiceCode", (Object)this.serviceCode()).add("CategoryCode", (Object)this.categoryCode()).add("SeverityCode", (Object)this.severityCode()).add("SubmittedBy", (Object)this.submittedBy()).add("TimeCreated", (Object)this.timeCreated()).add("RecentCommunications", (Object)this.recentCommunications()).add("CcEmailAddresses", this.hasCcEmailAddresses() ? this.ccEmailAddresses() : null).add("Language", (Object)this.language()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "displayId": {
                return Optional.ofNullable(clazz.cast(this.displayId()));
            }
            case "subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "serviceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "categoryCode": {
                return Optional.ofNullable(clazz.cast(this.categoryCode()));
            }
            case "severityCode": {
                return Optional.ofNullable(clazz.cast(this.severityCode()));
            }
            case "submittedBy": {
                return Optional.ofNullable(clazz.cast(this.submittedBy()));
            }
            case "timeCreated": {
                return Optional.ofNullable(clazz.cast(this.timeCreated()));
            }
            case "recentCommunications": {
                return Optional.ofNullable(clazz.cast(this.recentCommunications()));
            }
            case "ccEmailAddresses": {
                return Optional.ofNullable(clazz.cast(this.ccEmailAddresses()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaseDetails, T> g) {
        return obj -> g.apply((CaseDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String caseId;
        private String displayId;
        private String subject;
        private String status;
        private String serviceCode;
        private String categoryCode;
        private String severityCode;
        private String submittedBy;
        private String timeCreated;
        private RecentCaseCommunications recentCommunications;
        private List<String> ccEmailAddresses = DefaultSdkAutoConstructList.getInstance();
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseDetails model) {
            this.caseId(model.caseId);
            this.displayId(model.displayId);
            this.subject(model.subject);
            this.status(model.status);
            this.serviceCode(model.serviceCode);
            this.categoryCode(model.categoryCode);
            this.severityCode(model.severityCode);
            this.submittedBy(model.submittedBy);
            this.timeCreated(model.timeCreated);
            this.recentCommunications(model.recentCommunications);
            this.ccEmailAddresses(model.ccEmailAddresses);
            this.language(model.language);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getDisplayId() {
            return this.displayId;
        }

        public final void setDisplayId(String displayId) {
            this.displayId = displayId;
        }

        @Override
        public final Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getCategoryCode() {
            return this.categoryCode;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final String getSeverityCode() {
            return this.severityCode;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final String getSubmittedBy() {
            return this.submittedBy;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final String getTimeCreated() {
            return this.timeCreated;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final RecentCaseCommunications.Builder getRecentCommunications() {
            return this.recentCommunications != null ? this.recentCommunications.toBuilder() : null;
        }

        public final void setRecentCommunications(RecentCaseCommunications.BuilderImpl recentCommunications) {
            this.recentCommunications = recentCommunications != null ? recentCommunications.build() : null;
        }

        @Override
        public final Builder recentCommunications(RecentCaseCommunications recentCommunications) {
            this.recentCommunications = recentCommunications;
            return this;
        }

        public final Collection<String> getCcEmailAddresses() {
            if (this.ccEmailAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ccEmailAddresses;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String ... ccEmailAddresses) {
            this.ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public CaseDetails build() {
            return new CaseDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaseDetails> {
        public Builder caseId(String var1);

        public Builder displayId(String var1);

        public Builder subject(String var1);

        public Builder status(String var1);

        public Builder serviceCode(String var1);

        public Builder categoryCode(String var1);

        public Builder severityCode(String var1);

        public Builder submittedBy(String var1);

        public Builder timeCreated(String var1);

        public Builder recentCommunications(RecentCaseCommunications var1);

        default public Builder recentCommunications(Consumer<RecentCaseCommunications.Builder> recentCommunications) {
            return this.recentCommunications((RecentCaseCommunications)((RecentCaseCommunications.Builder)RecentCaseCommunications.builder().applyMutation(recentCommunications)).build());
        }

        public Builder ccEmailAddresses(Collection<String> var1);

        public Builder ccEmailAddresses(String ... var1);

        public Builder language(String var1);
    }
}

