/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAttachmentRequest extends SupportRequest implements
        ToCopyableBuilder<DescribeAttachmentRequest.Builder, DescribeAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAttachmentRequest::attachmentId)).setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD));

    private final String attachmentId;

    private DescribeAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
    }

    /**
     * <p>
     * The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a> operation.
     * </p>
     * 
     * @return The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a>
     *         operation.
     */
    public String attachmentId() {
        return attachmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAttachmentRequest)) {
            return false;
        }
        DescribeAttachmentRequest other = (DescribeAttachmentRequest) obj;
        return Objects.equals(attachmentId(), other.attachmentId());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAttachmentRequest").add("AttachmentId", attachmentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAttachmentRequest, T> g) {
        return obj -> g.apply((DescribeAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAttachmentRequest> {
        /**
         * <p>
         * The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a>
         * operation.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private String attachmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAttachmentRequest model) {
            super(model);
            attachmentId(model.attachmentId);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAttachmentRequest build() {
            return new DescribeAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
