/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A code and name pair that represent a severity level that can be applied to a support case.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SeverityLevel implements SdkPojo, Serializable, ToCopyableBuilder<SeverityLevel.Builder, SeverityLevel> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SeverityLevel::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SeverityLevel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String name;

    private SeverityLevel(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
    }

    /**
     * <p>
     * One of four values: "low," "medium," "high," and "urgent". These values correspond to response times returned to
     * the caller in <code>severityLevel.name</code>.
     * </p>
     * 
     * @return One of four values: "low," "medium," "high," and "urgent". These values correspond to response times
     *         returned to the caller in <code>severityLevel.name</code>.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * The name of the severity level that corresponds to the severity level code.
     * </p>
     * 
     * @return The name of the severity level that corresponds to the severity level code.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeverityLevel)) {
            return false;
        }
        SeverityLevel other = (SeverityLevel) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(name(), other.name());
    }

    @Override
    public String toString() {
        return ToString.builder("SeverityLevel").add("Code", code()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SeverityLevel, T> g) {
        return obj -> g.apply((SeverityLevel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SeverityLevel> {
        /**
         * <p>
         * One of four values: "low," "medium," "high," and "urgent". These values correspond to response times returned
         * to the caller in <code>severityLevel.name</code>.
         * </p>
         * 
         * @param code
         *        One of four values: "low," "medium," "high," and "urgent". These values correspond to response times
         *        returned to the caller in <code>severityLevel.name</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The name of the severity level that corresponds to the severity level code.
         * </p>
         * 
         * @param name
         *        The name of the severity level that corresponds to the severity level code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SeverityLevel model) {
            code(model.code);
            name(model.name);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public SeverityLevel build() {
            return new SeverityLevel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
