/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCaseRequest extends SupportRequest implements
        ToCopyableBuilder<CreateCaseRequest.Builder, CreateCaseRequest> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subject")
            .getter(getter(CreateCaseRequest::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(CreateCaseRequest::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> SEVERITY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severityCode").getter(getter(CreateCaseRequest::severityCode)).setter(setter(Builder::severityCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCode").build()).build();

    private static final SdkField<String> CATEGORY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("categoryCode").getter(getter(CreateCaseRequest::categoryCode)).setter(setter(Builder::categoryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoryCode").build()).build();

    private static final SdkField<String> COMMUNICATION_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("communicationBody").getter(getter(CreateCaseRequest::communicationBody))
            .setter(setter(Builder::communicationBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationBody").build()).build();

    private static final SdkField<List<String>> CC_EMAIL_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ccEmailAddresses")
            .getter(getter(CreateCaseRequest::ccEmailAddresses))
            .setter(setter(Builder::ccEmailAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccEmailAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(CreateCaseRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<String> ISSUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("issueType").getter(getter(CreateCaseRequest::issueType)).setter(setter(Builder::issueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issueType").build()).build();

    private static final SdkField<String> ATTACHMENT_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentSetId").getter(getter(CreateCaseRequest::attachmentSetId))
            .setter(setter(Builder::attachmentSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD,
            SERVICE_CODE_FIELD, SEVERITY_CODE_FIELD, CATEGORY_CODE_FIELD, COMMUNICATION_BODY_FIELD, CC_EMAIL_ADDRESSES_FIELD,
            LANGUAGE_FIELD, ISSUE_TYPE_FIELD, ATTACHMENT_SET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String subject;

    private final String serviceCode;

    private final String severityCode;

    private final String categoryCode;

    private final String communicationBody;

    private final List<String> ccEmailAddresses;

    private final String language;

    private final String issueType;

    private final String attachmentSetId;

    private CreateCaseRequest(BuilderImpl builder) {
        super(builder);
        this.subject = builder.subject;
        this.serviceCode = builder.serviceCode;
        this.severityCode = builder.severityCode;
        this.categoryCode = builder.categoryCode;
        this.communicationBody = builder.communicationBody;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
        this.issueType = builder.issueType;
        this.attachmentSetId = builder.attachmentSetId;
    }

    /**
     * <p>
     * The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services Support
     * Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.
     * </p>
     * 
     * @return The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services
     *         Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The code for the Amazon Web Services service. You can use the <a>DescribeServices</a> operation to get the
     * possible <code>serviceCode</code> values.
     * </p>
     * 
     * @return The code for the Amazon Web Services service. You can use the <a>DescribeServices</a> operation to get
     *         the possible <code>serviceCode</code> values.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * A value that indicates the urgency of the case. This value determines the response time according to your service
     * level agreement with Amazon Web Services Support. You can use the <a>DescribeSeverityLevels</a> operation to get
     * the possible values for <code>severityCode</code>.
     * </p>
     * <p>
     * For more information, see <a>SeverityLevel</a> and <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a
     * Severity</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The availability of severity levels depends on the support plan for the Amazon Web Services account.
     * </p>
     * </note>
     * 
     * @return A value that indicates the urgency of the case. This value determines the response time according to your
     *         service level agreement with Amazon Web Services Support. You can use the <a>DescribeSeverityLevels</a>
     *         operation to get the possible values for <code>severityCode</code>. </p>
     *         <p>
     *         For more information, see <a>SeverityLevel</a> and <a
     *         href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing
     *         a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         The availability of severity levels depends on the support plan for the Amazon Web Services account.
     *         </p>
     */
    public final String severityCode() {
        return severityCode;
    }

    /**
     * <p>
     * The category of problem for the support case. You also use the <a>DescribeServices</a> operation to get the
     * category code for a service. Each Amazon Web Services service defines its own set of category codes.
     * </p>
     * 
     * @return The category of problem for the support case. You also use the <a>DescribeServices</a> operation to get
     *         the category code for a service. Each Amazon Web Services service defines its own set of category codes.
     */
    public final String categoryCode() {
        return categoryCode;
    }

    /**
     * <p>
     * The communication body text that describes the issue. This text appears in the <b>Description</b> field on the
     * Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create
     * Case</a> page.
     * </p>
     * 
     * @return The communication body text that describes the issue. This text appears in the <b>Description</b> field
     *         on the Amazon Web Services Support Center <a
     *         href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.
     */
    public final String communicationBody() {
        return communicationBody;
    }

    /**
     * For responses, this returns true if the service returned a value for the CcEmailAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCcEmailAddresses() {
        return ccEmailAddresses != null && !(ccEmailAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services
     * Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an
     * HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCcEmailAddresses} method.
     * </p>
     * 
     * @return A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web
     *         Services Support identifies the account that creates the case when you specify your Amazon Web Services
     *         credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services
     *         SDKs</a>.
     */
    public final List<String> ccEmailAddresses() {
        return ccEmailAddresses;
    }

    /**
     * <p>
     * The language in which Amazon Web Services Support handles the case. Amazon Web Services Support currently
     * supports Chinese (“zh”), English ("en"), Japanese ("ja") and Korean (“ko”). You must specify the ISO 639-1 code
     * for the <code>language</code> parameter if you want support in that language.
     * </p>
     * 
     * @return The language in which Amazon Web Services Support handles the case. Amazon Web Services Support currently
     *         supports Chinese (“zh”), English ("en"), Japanese ("ja") and Korean (“ko”). You must specify the ISO
     *         639-1 code for the <code>language</code> parameter if you want support in that language.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If you
     * don't specify a value, the default is <code>technical</code>.
     * </p>
     * 
     * @return The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>.
     *         If you don't specify a value, the default is <code>technical</code>.
     */
    public final String issueType() {
        return issueType;
    }

    /**
     * <p>
     * The ID of a set of one or more attachments for the case. Create the set by using the <a>AddAttachmentsToSet</a>
     * operation.
     * </p>
     * 
     * @return The ID of a set of one or more attachments for the case. Create the set by using the
     *         <a>AddAttachmentsToSet</a> operation.
     */
    public final String attachmentSetId() {
        return attachmentSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(severityCode());
        hashCode = 31 * hashCode + Objects.hashCode(categoryCode());
        hashCode = 31 * hashCode + Objects.hashCode(communicationBody());
        hashCode = 31 * hashCode + Objects.hashCode(hasCcEmailAddresses() ? ccEmailAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(issueType());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseRequest)) {
            return false;
        }
        CreateCaseRequest other = (CreateCaseRequest) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(serviceCode(), other.serviceCode())
                && Objects.equals(severityCode(), other.severityCode()) && Objects.equals(categoryCode(), other.categoryCode())
                && Objects.equals(communicationBody(), other.communicationBody())
                && hasCcEmailAddresses() == other.hasCcEmailAddresses()
                && Objects.equals(ccEmailAddresses(), other.ccEmailAddresses()) && Objects.equals(language(), other.language())
                && Objects.equals(issueType(), other.issueType()) && Objects.equals(attachmentSetId(), other.attachmentSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCaseRequest").add("Subject", subject()).add("ServiceCode", serviceCode())
                .add("SeverityCode", severityCode()).add("CategoryCode", categoryCode())
                .add("CommunicationBody", communicationBody())
                .add("CcEmailAddresses", hasCcEmailAddresses() ? ccEmailAddresses() : null).add("Language", language())
                .add("IssueType", issueType()).add("AttachmentSetId", attachmentSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "severityCode":
            return Optional.ofNullable(clazz.cast(severityCode()));
        case "categoryCode":
            return Optional.ofNullable(clazz.cast(categoryCode()));
        case "communicationBody":
            return Optional.ofNullable(clazz.cast(communicationBody()));
        case "ccEmailAddresses":
            return Optional.ofNullable(clazz.cast(ccEmailAddresses()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "issueType":
            return Optional.ofNullable(clazz.cast(issueType()));
        case "attachmentSetId":
            return Optional.ofNullable(clazz.cast(attachmentSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("subject", SUBJECT_FIELD);
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("severityCode", SEVERITY_CODE_FIELD);
        map.put("categoryCode", CATEGORY_CODE_FIELD);
        map.put("communicationBody", COMMUNICATION_BODY_FIELD);
        map.put("ccEmailAddresses", CC_EMAIL_ADDRESSES_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("issueType", ISSUE_TYPE_FIELD);
        map.put("attachmentSetId", ATTACHMENT_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCaseRequest, T> g) {
        return obj -> g.apply((CreateCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCaseRequest> {
        /**
         * <p>
         * The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services
         * Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.
         * </p>
         * 
         * @param subject
         *        The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web
         *        Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create
         *        Case</a> page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The code for the Amazon Web Services service. You can use the <a>DescribeServices</a> operation to get the
         * possible <code>serviceCode</code> values.
         * </p>
         * 
         * @param serviceCode
         *        The code for the Amazon Web Services service. You can use the <a>DescribeServices</a> operation to get
         *        the possible <code>serviceCode</code> values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * A value that indicates the urgency of the case. This value determines the response time according to your
         * service level agreement with Amazon Web Services Support. You can use the <a>DescribeSeverityLevels</a>
         * operation to get the possible values for <code>severityCode</code>.
         * </p>
         * <p>
         * For more information, see <a>SeverityLevel</a> and <a
         * href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a
         * Severity</a> in the <i>Amazon Web Services Support User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The availability of severity levels depends on the support plan for the Amazon Web Services account.
         * </p>
         * </note>
         * 
         * @param severityCode
         *        A value that indicates the urgency of the case. This value determines the response time according to
         *        your service level agreement with Amazon Web Services Support. You can use the
         *        <a>DescribeSeverityLevels</a> operation to get the possible values for <code>severityCode</code>. </p>
         *        <p>
         *        For more information, see <a>SeverityLevel</a> and <a
         *        href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity"
         *        >Choosing a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The availability of severity levels depends on the support plan for the Amazon Web Services account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCode(String severityCode);

        /**
         * <p>
         * The category of problem for the support case. You also use the <a>DescribeServices</a> operation to get the
         * category code for a service. Each Amazon Web Services service defines its own set of category codes.
         * </p>
         * 
         * @param categoryCode
         *        The category of problem for the support case. You also use the <a>DescribeServices</a> operation to
         *        get the category code for a service. Each Amazon Web Services service defines its own set of category
         *        codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryCode(String categoryCode);

        /**
         * <p>
         * The communication body text that describes the issue. This text appears in the <b>Description</b> field on
         * the Amazon Web Services Support Center <a
         * href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.
         * </p>
         * 
         * @param communicationBody
         *        The communication body text that describes the issue. This text appears in the <b>Description</b>
         *        field on the Amazon Web Services Support Center <a
         *        href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationBody(String communicationBody);

        /**
         * <p>
         * A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services
         * Support identifies the account that creates the case when you specify your Amazon Web Services credentials in
         * an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>.
         * </p>
         * 
         * @param ccEmailAddresses
         *        A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web
         *        Services Support identifies the account that creates the case when you specify your Amazon Web
         *        Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon
         *        Web Services SDKs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(Collection<String> ccEmailAddresses);

        /**
         * <p>
         * A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services
         * Support identifies the account that creates the case when you specify your Amazon Web Services credentials in
         * an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>.
         * </p>
         * 
         * @param ccEmailAddresses
         *        A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web
         *        Services Support identifies the account that creates the case when you specify your Amazon Web
         *        Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon
         *        Web Services SDKs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(String... ccEmailAddresses);

        /**
         * <p>
         * The language in which Amazon Web Services Support handles the case. Amazon Web Services Support currently
         * supports Chinese (“zh”), English ("en"), Japanese ("ja") and Korean (“ko”). You must specify the ISO 639-1
         * code for the <code>language</code> parameter if you want support in that language.
         * </p>
         * 
         * @param language
         *        The language in which Amazon Web Services Support handles the case. Amazon Web Services Support
         *        currently supports Chinese (“zh”), English ("en"), Japanese ("ja") and Korean (“ko”). You must specify
         *        the ISO 639-1 code for the <code>language</code> parameter if you want support in that language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If
         * you don't specify a value, the default is <code>technical</code>.
         * </p>
         * 
         * @param issueType
         *        The type of issue for the case. You can specify <code>customer-service</code> or
         *        <code>technical</code>. If you don't specify a value, the default is <code>technical</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueType(String issueType);

        /**
         * <p>
         * The ID of a set of one or more attachments for the case. Create the set by using the
         * <a>AddAttachmentsToSet</a> operation.
         * </p>
         * 
         * @param attachmentSetId
         *        The ID of a set of one or more attachments for the case. Create the set by using the
         *        <a>AddAttachmentsToSet</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSetId(String attachmentSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private String subject;

        private String serviceCode;

        private String severityCode;

        private String categoryCode;

        private String communicationBody;

        private List<String> ccEmailAddresses = DefaultSdkAutoConstructList.getInstance();

        private String language;

        private String issueType;

        private String attachmentSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCaseRequest model) {
            super(model);
            subject(model.subject);
            serviceCode(model.serviceCode);
            severityCode(model.severityCode);
            categoryCode(model.categoryCode);
            communicationBody(model.communicationBody);
            ccEmailAddresses(model.ccEmailAddresses);
            language(model.language);
            issueType(model.issueType);
            attachmentSetId(model.attachmentSetId);
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getSeverityCode() {
            return severityCode;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final String getCategoryCode() {
            return categoryCode;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final String getCommunicationBody() {
            return communicationBody;
        }

        public final void setCommunicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
        }

        @Override
        public final Builder communicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
            return this;
        }

        public final Collection<String> getCcEmailAddresses() {
            if (ccEmailAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ccEmailAddresses;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String... ccEmailAddresses) {
            ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getIssueType() {
            return issueType;
        }

        public final void setIssueType(String issueType) {
            this.issueType = issueType;
        }

        @Override
        public final Builder issueType(String issueType) {
            this.issueType = issueType;
            return this;
        }

        public final String getAttachmentSetId() {
            return attachmentSetId;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCaseRequest build() {
            return new CreateCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
