/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSupportedLanguagesResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeSupportedLanguagesResponse.Builder, DescribeSupportedLanguagesResponse> {
    private static final SdkField<List<SupportedLanguage>> SUPPORTED_LANGUAGES_FIELD = SdkField
            .<List<SupportedLanguage>> builder(MarshallingType.LIST)
            .memberName("supportedLanguages")
            .getter(getter(DescribeSupportedLanguagesResponse::supportedLanguages))
            .setter(setter(Builder::supportedLanguages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedLanguages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupportedLanguage> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedLanguage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_LANGUAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SupportedLanguage> supportedLanguages;

    private DescribeSupportedLanguagesResponse(BuilderImpl builder) {
        super(builder);
        this.supportedLanguages = builder.supportedLanguages;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedLanguages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedLanguages() {
        return supportedLanguages != null && !(supportedLanguages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON-formatted array that contains the available ISO 639-1 language codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedLanguages} method.
     * </p>
     * 
     * @return A JSON-formatted array that contains the available ISO 639-1 language codes.
     */
    public final List<SupportedLanguage> supportedLanguages() {
        return supportedLanguages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedLanguages() ? supportedLanguages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSupportedLanguagesResponse)) {
            return false;
        }
        DescribeSupportedLanguagesResponse other = (DescribeSupportedLanguagesResponse) obj;
        return hasSupportedLanguages() == other.hasSupportedLanguages()
                && Objects.equals(supportedLanguages(), other.supportedLanguages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSupportedLanguagesResponse")
                .add("SupportedLanguages", hasSupportedLanguages() ? supportedLanguages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "supportedLanguages":
            return Optional.ofNullable(clazz.cast(supportedLanguages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("supportedLanguages", SUPPORTED_LANGUAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSupportedLanguagesResponse, T> g) {
        return obj -> g.apply((DescribeSupportedLanguagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSupportedLanguagesResponse> {
        /**
         * <p>
         * A JSON-formatted array that contains the available ISO 639-1 language codes.
         * </p>
         * 
         * @param supportedLanguages
         *        A JSON-formatted array that contains the available ISO 639-1 language codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLanguages(Collection<SupportedLanguage> supportedLanguages);

        /**
         * <p>
         * A JSON-formatted array that contains the available ISO 639-1 language codes.
         * </p>
         * 
         * @param supportedLanguages
         *        A JSON-formatted array that contains the available ISO 639-1 language codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLanguages(SupportedLanguage... supportedLanguages);

        /**
         * <p>
         * A JSON-formatted array that contains the available ISO 639-1 language codes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.support.model.SupportedLanguage.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.support.model.SupportedLanguage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.support.model.SupportedLanguage.Builder#build()} is called immediately
         * and its result is passed to {@link #supportedLanguages(List<SupportedLanguage>)}.
         * 
         * @param supportedLanguages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.support.model.SupportedLanguage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedLanguages(java.util.Collection<SupportedLanguage>)
         */
        Builder supportedLanguages(Consumer<SupportedLanguage.Builder>... supportedLanguages);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<SupportedLanguage> supportedLanguages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSupportedLanguagesResponse model) {
            super(model);
            supportedLanguages(model.supportedLanguages);
        }

        public final List<SupportedLanguage.Builder> getSupportedLanguages() {
            List<SupportedLanguage.Builder> result = SupportedLanguagesListCopier.copyToBuilder(this.supportedLanguages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedLanguages(Collection<SupportedLanguage.BuilderImpl> supportedLanguages) {
            this.supportedLanguages = SupportedLanguagesListCopier.copyFromBuilder(supportedLanguages);
        }

        @Override
        public final Builder supportedLanguages(Collection<SupportedLanguage> supportedLanguages) {
            this.supportedLanguages = SupportedLanguagesListCopier.copy(supportedLanguages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLanguages(SupportedLanguage... supportedLanguages) {
            supportedLanguages(Arrays.asList(supportedLanguages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLanguages(Consumer<SupportedLanguage.Builder>... supportedLanguages) {
            supportedLanguages(Stream.of(supportedLanguages).map(c -> SupportedLanguage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSupportedLanguagesResponse build() {
            return new DescribeSupportedLanguagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
