/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON-formatted object that contains the available ISO 639-1 language <code>code</code>, <code>language</code> name
 * and langauge <code>display</code> value. The language code is what should be used in the <a>CreateCase</a> call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedLanguage implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedLanguage.Builder, SupportedLanguage> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(SupportedLanguage::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(SupportedLanguage::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<String> DISPLAY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("display")
            .getter(getter(SupportedLanguage::display)).setter(setter(Builder::display))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("display").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, LANGUAGE_FIELD,
            DISPLAY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String language;

    private final String display;

    private SupportedLanguage(BuilderImpl builder) {
        this.code = builder.code;
        this.language = builder.language;
        this.display = builder.display;
    }

    /**
     * <p>
     * 2 digit ISO 639-1 code. e.g. <code>en</code>
     * </p>
     * 
     * @return 2 digit ISO 639-1 code. e.g. <code>en</code>
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * Full language description e.g. <code>ENGLISH</code>
     * </p>
     * 
     * @return Full language description e.g. <code>ENGLISH</code>
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * Language display value e.g. <code>ENGLISH</code>
     * </p>
     * 
     * @return Language display value e.g. <code>ENGLISH</code>
     */
    public final String display() {
        return display;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(display());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedLanguage)) {
            return false;
        }
        SupportedLanguage other = (SupportedLanguage) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(language(), other.language())
                && Objects.equals(display(), other.display());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedLanguage").add("Code", code()).add("Language", language()).add("Display", display())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "display":
            return Optional.ofNullable(clazz.cast(display()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("code", CODE_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("display", DISPLAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedLanguage, T> g) {
        return obj -> g.apply((SupportedLanguage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedLanguage> {
        /**
         * <p>
         * 2 digit ISO 639-1 code. e.g. <code>en</code>
         * </p>
         * 
         * @param code
         *        2 digit ISO 639-1 code. e.g. <code>en</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * Full language description e.g. <code>ENGLISH</code>
         * </p>
         * 
         * @param language
         *        Full language description e.g. <code>ENGLISH</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * Language display value e.g. <code>ENGLISH</code>
         * </p>
         * 
         * @param display
         *        Language display value e.g. <code>ENGLISH</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder display(String display);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String language;

        private String display;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedLanguage model) {
            code(model.code);
            language(model.language);
            display(model.display);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getDisplay() {
            return display;
        }

        public final void setDisplay(String display) {
            this.display = display;
        }

        @Override
        public final Builder display(String display) {
            this.display = display;
            return this;
        }

        @Override
        public SupportedLanguage build() {
            return new SupportedLanguage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
