/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.support.SupportAsyncClient;
import software.amazon.awssdk.services.support.SupportServiceClientConfiguration;
import software.amazon.awssdk.services.support.internal.SupportServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetRequest;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetResponse;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseRequest;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseResponse;
import software.amazon.awssdk.services.support.model.AttachmentIdNotFoundException;
import software.amazon.awssdk.services.support.model.AttachmentLimitExceededException;
import software.amazon.awssdk.services.support.model.AttachmentSetExpiredException;
import software.amazon.awssdk.services.support.model.AttachmentSetIdNotFoundException;
import software.amazon.awssdk.services.support.model.AttachmentSetSizeLimitExceededException;
import software.amazon.awssdk.services.support.model.CaseCreationLimitExceededException;
import software.amazon.awssdk.services.support.model.CaseIdNotFoundException;
import software.amazon.awssdk.services.support.model.CreateCaseRequest;
import software.amazon.awssdk.services.support.model.CreateCaseResponse;
import software.amazon.awssdk.services.support.model.DescribeAttachmentLimitExceededException;
import software.amazon.awssdk.services.support.model.DescribeAttachmentRequest;
import software.amazon.awssdk.services.support.model.DescribeAttachmentResponse;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.services.support.model.DescribeCasesResponse;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse;
import software.amazon.awssdk.services.support.model.DescribeCreateCaseOptionsRequest;
import software.amazon.awssdk.services.support.model.DescribeCreateCaseOptionsResponse;
import software.amazon.awssdk.services.support.model.DescribeServicesRequest;
import software.amazon.awssdk.services.support.model.DescribeServicesResponse;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsRequest;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsResponse;
import software.amazon.awssdk.services.support.model.DescribeSupportedLanguagesRequest;
import software.amazon.awssdk.services.support.model.DescribeSupportedLanguagesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksResponse;
import software.amazon.awssdk.services.support.model.InternalServerErrorException;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckRequest;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckResponse;
import software.amazon.awssdk.services.support.model.ResolveCaseRequest;
import software.amazon.awssdk.services.support.model.ResolveCaseResponse;
import software.amazon.awssdk.services.support.model.SupportException;
import software.amazon.awssdk.services.support.model.ThrottlingException;
import software.amazon.awssdk.services.support.transform.AddAttachmentsToSetRequestMarshaller;
import software.amazon.awssdk.services.support.transform.AddCommunicationToCaseRequestMarshaller;
import software.amazon.awssdk.services.support.transform.CreateCaseRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeAttachmentRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCasesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCommunicationsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCreateCaseOptionsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeSeverityLevelsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeSupportedLanguagesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckResultRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckSummariesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorChecksRequestMarshaller;
import software.amazon.awssdk.services.support.transform.RefreshTrustedAdvisorCheckRequestMarshaller;
import software.amazon.awssdk.services.support.transform.ResolveCaseRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSupportAsyncClient
implements SupportAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSupportAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSupportAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Support#2.31.78").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AddAttachmentsToSetResponse> addAttachmentsToSet(AddAttachmentsToSetRequest addAttachmentsToSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addAttachmentsToSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, addAttachmentsToSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddAttachmentsToSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddAttachmentsToSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddAttachmentsToSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddAttachmentsToSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addAttachmentsToSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$addAttachmentsToSet$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$addAttachmentsToSet$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddCommunicationToCaseResponse> addCommunicationToCase(AddCommunicationToCaseRequest addCommunicationToCaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addCommunicationToCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, addCommunicationToCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddCommunicationToCase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddCommunicationToCaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddCommunicationToCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddCommunicationToCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addCommunicationToCaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$addCommunicationToCase$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$addCommunicationToCase$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCaseResponse> createCase(CreateCaseRequest createCaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, createCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$createCase$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$createCase$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAttachmentResponse> describeAttachment(DescribeAttachmentRequest describeAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeAttachmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAttachmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAttachment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAttachmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAttachmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeAttachment$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeAttachment$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCasesResponse> describeCases(DescribeCasesRequest describeCasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeCasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeCases$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeCases$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCommunicationsResponse> describeCommunications(DescribeCommunicationsRequest describeCommunicationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCommunicationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeCommunicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCommunications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCommunicationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCommunications").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCommunicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCommunicationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeCommunications$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeCommunications$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCreateCaseOptionsResponse> describeCreateCaseOptions(DescribeCreateCaseOptionsRequest describeCreateCaseOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCreateCaseOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeCreateCaseOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCreateCaseOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCreateCaseOptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCreateCaseOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCreateCaseOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCreateCaseOptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeCreateCaseOptions$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeCreateCaseOptions$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeServicesResponse> describeServices(DescribeServicesRequest describeServicesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServicesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeServicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeServices$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeServices$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSeverityLevelsResponse> describeSeverityLevels(DescribeSeverityLevelsRequest describeSeverityLevelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSeverityLevelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeSeverityLevelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSeverityLevels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSeverityLevelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSeverityLevels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSeverityLevelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSeverityLevelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeSeverityLevels$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeSeverityLevels$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSupportedLanguagesResponse> describeSupportedLanguages(DescribeSupportedLanguagesRequest describeSupportedLanguagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSupportedLanguagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeSupportedLanguagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSupportedLanguages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSupportedLanguagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSupportedLanguages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSupportedLanguagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSupportedLanguagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeSupportedLanguages$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeSupportedLanguages$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTrustedAdvisorCheckRefreshStatusesResponse> describeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustedAdvisorCheckRefreshStatusesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeTrustedAdvisorCheckRefreshStatusesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrustedAdvisorCheckRefreshStatuses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorCheckRefreshStatusesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorCheckRefreshStatuses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTrustedAdvisorCheckRefreshStatusesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeTrustedAdvisorCheckRefreshStatuses$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeTrustedAdvisorCheckRefreshStatuses$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTrustedAdvisorCheckResultResponse> describeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustedAdvisorCheckResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeTrustedAdvisorCheckResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrustedAdvisorCheckResult");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorCheckResultResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorCheckResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTrustedAdvisorCheckResultRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeTrustedAdvisorCheckResult$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeTrustedAdvisorCheckResult$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTrustedAdvisorCheckSummariesResponse> describeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustedAdvisorCheckSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeTrustedAdvisorCheckSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrustedAdvisorCheckSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorCheckSummariesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorCheckSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTrustedAdvisorCheckSummariesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeTrustedAdvisorCheckSummaries$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeTrustedAdvisorCheckSummaries$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTrustedAdvisorChecksResponse> describeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustedAdvisorChecksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, describeTrustedAdvisorChecksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrustedAdvisorChecks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorChecksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorChecks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTrustedAdvisorChecksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTrustedAdvisorChecksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$describeTrustedAdvisorChecks$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$describeTrustedAdvisorChecks$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RefreshTrustedAdvisorCheckResponse> refreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)refreshTrustedAdvisorCheckRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, refreshTrustedAdvisorCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RefreshTrustedAdvisorCheck");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RefreshTrustedAdvisorCheckResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RefreshTrustedAdvisorCheck").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RefreshTrustedAdvisorCheckRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)refreshTrustedAdvisorCheckRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$refreshTrustedAdvisorCheck$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$refreshTrustedAdvisorCheck$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResolveCaseResponse> resolveCase(ResolveCaseRequest resolveCaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resolveCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportAsyncClient.resolveMetricPublishers(clientConfiguration, resolveCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResolveCase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResolveCaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AttachmentSetIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                    }
                    case "CaseCreationLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                    }
                    case "AttachmentIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                    }
                    case "AttachmentSetExpired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "AttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                    }
                    case "CaseIdNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                    }
                    case "DescribeAttachmentLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                    case "AttachmentSetSizeLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResolveCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResolveCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resolveCaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSupportAsyncClient.lambda$resolveCase$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSupportAsyncClient.lambda$resolveCase$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final SupportServiceClientConfiguration serviceClientConfiguration() {
        return new SupportServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "support";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SupportException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        SupportServiceClientConfigurationBuilder serviceConfigBuilder = new SupportServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$resolveCase$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resolveCase$62(List metricPublishers, MetricCollector apiCallMetricCollector, ResolveCaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$refreshTrustedAdvisorCheck$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$refreshTrustedAdvisorCheck$58(List metricPublishers, MetricCollector apiCallMetricCollector, RefreshTrustedAdvisorCheckResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorChecks$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorChecks$54(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTrustedAdvisorChecksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorCheckSummaries$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorCheckSummaries$50(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTrustedAdvisorCheckSummariesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorCheckResult$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorCheckResult$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTrustedAdvisorCheckResultResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorCheckRefreshStatuses$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorCheckRefreshStatuses$42(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTrustedAdvisorCheckRefreshStatusesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSupportedLanguages$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSupportedLanguages$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSupportedLanguagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSeverityLevels$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSeverityLevels$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSeverityLevelsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeServices$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServices$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeServicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCreateCaseOptions$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCreateCaseOptions$26(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCreateCaseOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCommunications$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCommunications$22(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCommunicationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCases$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCases$18(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAttachment$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAttachment$14(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAttachmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCase$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCase$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addCommunicationToCase$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addCommunicationToCase$6(List metricPublishers, MetricCollector apiCallMetricCollector, AddCommunicationToCaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addAttachmentsToSet$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addAttachmentsToSet$2(List metricPublishers, MetricCollector apiCallMetricCollector, AddAttachmentsToSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

