/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.support.SupportClient;
import software.amazon.awssdk.services.support.SupportServiceClientConfiguration;
import software.amazon.awssdk.services.support.internal.SupportServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetRequest;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetResponse;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseRequest;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseResponse;
import software.amazon.awssdk.services.support.model.AttachmentIdNotFoundException;
import software.amazon.awssdk.services.support.model.AttachmentLimitExceededException;
import software.amazon.awssdk.services.support.model.AttachmentSetExpiredException;
import software.amazon.awssdk.services.support.model.AttachmentSetIdNotFoundException;
import software.amazon.awssdk.services.support.model.AttachmentSetSizeLimitExceededException;
import software.amazon.awssdk.services.support.model.CaseCreationLimitExceededException;
import software.amazon.awssdk.services.support.model.CaseIdNotFoundException;
import software.amazon.awssdk.services.support.model.CreateCaseRequest;
import software.amazon.awssdk.services.support.model.CreateCaseResponse;
import software.amazon.awssdk.services.support.model.DescribeAttachmentLimitExceededException;
import software.amazon.awssdk.services.support.model.DescribeAttachmentRequest;
import software.amazon.awssdk.services.support.model.DescribeAttachmentResponse;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.services.support.model.DescribeCasesResponse;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse;
import software.amazon.awssdk.services.support.model.DescribeCreateCaseOptionsRequest;
import software.amazon.awssdk.services.support.model.DescribeCreateCaseOptionsResponse;
import software.amazon.awssdk.services.support.model.DescribeServicesRequest;
import software.amazon.awssdk.services.support.model.DescribeServicesResponse;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsRequest;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsResponse;
import software.amazon.awssdk.services.support.model.DescribeSupportedLanguagesRequest;
import software.amazon.awssdk.services.support.model.DescribeSupportedLanguagesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksResponse;
import software.amazon.awssdk.services.support.model.InternalServerErrorException;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckRequest;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckResponse;
import software.amazon.awssdk.services.support.model.ResolveCaseRequest;
import software.amazon.awssdk.services.support.model.ResolveCaseResponse;
import software.amazon.awssdk.services.support.model.SupportException;
import software.amazon.awssdk.services.support.model.ThrottlingException;
import software.amazon.awssdk.services.support.transform.AddAttachmentsToSetRequestMarshaller;
import software.amazon.awssdk.services.support.transform.AddCommunicationToCaseRequestMarshaller;
import software.amazon.awssdk.services.support.transform.CreateCaseRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeAttachmentRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCasesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCommunicationsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCreateCaseOptionsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeSeverityLevelsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeSupportedLanguagesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckResultRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckSummariesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorChecksRequestMarshaller;
import software.amazon.awssdk.services.support.transform.RefreshTrustedAdvisorCheckRequestMarshaller;
import software.amazon.awssdk.services.support.transform.ResolveCaseRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSupportClient
implements SupportClient {
    private static final Logger log = Logger.loggerFor(DefaultSupportClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSupportClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Support#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddAttachmentsToSetResponse addAttachmentsToSet(AddAttachmentsToSetRequest addAttachmentsToSetRequest) throws InternalServerErrorException, AttachmentSetIdNotFoundException, AttachmentSetExpiredException, AttachmentSetSizeLimitExceededException, AttachmentLimitExceededException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddAttachmentsToSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addAttachmentsToSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, addAttachmentsToSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddAttachmentsToSet");
            AddAttachmentsToSetResponse addAttachmentsToSetResponse = (AddAttachmentsToSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddAttachmentsToSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addAttachmentsToSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddAttachmentsToSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addAttachmentsToSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$addAttachmentsToSet$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddCommunicationToCaseResponse addCommunicationToCase(AddCommunicationToCaseRequest addCommunicationToCaseRequest) throws InternalServerErrorException, CaseIdNotFoundException, AttachmentSetIdNotFoundException, AttachmentSetExpiredException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddCommunicationToCaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addCommunicationToCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, addCommunicationToCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddCommunicationToCase");
            AddCommunicationToCaseResponse addCommunicationToCaseResponse = (AddCommunicationToCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddCommunicationToCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addCommunicationToCaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddCommunicationToCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addCommunicationToCaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$addCommunicationToCase$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCaseResponse createCase(CreateCaseRequest createCaseRequest) throws InternalServerErrorException, CaseCreationLimitExceededException, AttachmentSetIdNotFoundException, AttachmentSetExpiredException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, createCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCase");
            CreateCaseResponse createCaseResponse = (CreateCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$createCase$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAttachmentResponse describeAttachment(DescribeAttachmentRequest describeAttachmentRequest) throws InternalServerErrorException, DescribeAttachmentLimitExceededException, AttachmentIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAttachmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeAttachmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAttachment");
            DescribeAttachmentResponse describeAttachmentResponse = (DescribeAttachmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAttachment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAttachmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAttachmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAttachmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeAttachment$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCasesResponse describeCases(DescribeCasesRequest describeCasesRequest) throws InternalServerErrorException, CaseIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeCasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCases");
            DescribeCasesResponse describeCasesResponse = (DescribeCasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeCases$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCommunicationsResponse describeCommunications(DescribeCommunicationsRequest describeCommunicationsRequest) throws InternalServerErrorException, CaseIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCommunicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCommunicationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeCommunicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCommunications");
            DescribeCommunicationsResponse describeCommunicationsResponse = (DescribeCommunicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCommunications").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCommunicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCommunicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCommunicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeCommunications$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCreateCaseOptionsResponse describeCreateCaseOptions(DescribeCreateCaseOptionsRequest describeCreateCaseOptionsRequest) throws InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCreateCaseOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCreateCaseOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeCreateCaseOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCreateCaseOptions");
            DescribeCreateCaseOptionsResponse describeCreateCaseOptionsResponse = (DescribeCreateCaseOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCreateCaseOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCreateCaseOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCreateCaseOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCreateCaseOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeCreateCaseOptions$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServicesResponse describeServices(DescribeServicesRequest describeServicesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServices");
            DescribeServicesResponse describeServicesResponse = (DescribeServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeServices$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSeverityLevelsResponse describeSeverityLevels(DescribeSeverityLevelsRequest describeSeverityLevelsRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSeverityLevelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSeverityLevelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeSeverityLevelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSeverityLevels");
            DescribeSeverityLevelsResponse describeSeverityLevelsResponse = (DescribeSeverityLevelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSeverityLevels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSeverityLevelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSeverityLevelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSeverityLevelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeSeverityLevels$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSupportedLanguagesResponse describeSupportedLanguages(DescribeSupportedLanguagesRequest describeSupportedLanguagesRequest) throws InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSupportedLanguagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSupportedLanguagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeSupportedLanguagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSupportedLanguages");
            DescribeSupportedLanguagesResponse describeSupportedLanguagesResponse = (DescribeSupportedLanguagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSupportedLanguages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSupportedLanguagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSupportedLanguagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSupportedLanguagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeSupportedLanguages$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustedAdvisorCheckRefreshStatusesResponse describeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest) throws InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorCheckRefreshStatusesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustedAdvisorCheckRefreshStatusesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeTrustedAdvisorCheckRefreshStatusesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrustedAdvisorCheckRefreshStatuses");
            DescribeTrustedAdvisorCheckRefreshStatusesResponse describeTrustedAdvisorCheckRefreshStatusesResponse = (DescribeTrustedAdvisorCheckRefreshStatusesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorCheckRefreshStatuses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTrustedAdvisorCheckRefreshStatusesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTrustedAdvisorCheckRefreshStatusesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeTrustedAdvisorCheckRefreshStatuses$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustedAdvisorCheckResultResponse describeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest) throws InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorCheckResultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustedAdvisorCheckResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeTrustedAdvisorCheckResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrustedAdvisorCheckResult");
            DescribeTrustedAdvisorCheckResultResponse describeTrustedAdvisorCheckResultResponse = (DescribeTrustedAdvisorCheckResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorCheckResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTrustedAdvisorCheckResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTrustedAdvisorCheckResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeTrustedAdvisorCheckResult$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustedAdvisorCheckSummariesResponse describeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest) throws InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorCheckSummariesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustedAdvisorCheckSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeTrustedAdvisorCheckSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrustedAdvisorCheckSummaries");
            DescribeTrustedAdvisorCheckSummariesResponse describeTrustedAdvisorCheckSummariesResponse = (DescribeTrustedAdvisorCheckSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorCheckSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTrustedAdvisorCheckSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTrustedAdvisorCheckSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeTrustedAdvisorCheckSummaries$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustedAdvisorChecksResponse describeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest) throws InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedAdvisorChecksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustedAdvisorChecksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, describeTrustedAdvisorChecksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrustedAdvisorChecks");
            DescribeTrustedAdvisorChecksResponse describeTrustedAdvisorChecksResponse = (DescribeTrustedAdvisorChecksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedAdvisorChecks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTrustedAdvisorChecksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrustedAdvisorChecksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTrustedAdvisorChecksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$describeTrustedAdvisorChecks$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefreshTrustedAdvisorCheckResponse refreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RefreshTrustedAdvisorCheckResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)refreshTrustedAdvisorCheckRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, refreshTrustedAdvisorCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RefreshTrustedAdvisorCheck");
            RefreshTrustedAdvisorCheckResponse refreshTrustedAdvisorCheckResponse = (RefreshTrustedAdvisorCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RefreshTrustedAdvisorCheck").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)refreshTrustedAdvisorCheckRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RefreshTrustedAdvisorCheckRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return refreshTrustedAdvisorCheckResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$refreshTrustedAdvisorCheck$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolveCaseResponse resolveCase(ResolveCaseRequest resolveCaseRequest) throws InternalServerErrorException, CaseIdNotFoundException, AwsServiceException, SdkClientException, SupportException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResolveCaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AttachmentSetIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetIdNotFoundException::builder).build());
                }
                case "CaseCreationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "AttachmentIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentIdNotFoundException::builder).build());
                }
                case "AttachmentSetExpired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetExpired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetExpiredException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentLimitExceededException::builder).build());
                }
                case "CaseIdNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseIdNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CaseIdNotFoundException::builder).build());
                }
                case "DescribeAttachmentLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescribeAttachmentLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DescribeAttachmentLimitExceededException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
                case "AttachmentSetSizeLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentSetSizeLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentSetSizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resolveCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSupportClient.resolveMetricPublishers(clientConfiguration, resolveCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResolveCase");
            ResolveCaseResponse resolveCaseResponse = (ResolveCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResolveCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resolveCaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResolveCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resolveCaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportClient.lambda$resolveCase$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "support";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SupportServiceClientConfigurationBuilder serviceConfigBuilder = new SupportServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SupportException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final SupportServiceClientConfiguration serviceClientConfiguration() {
        return new SupportServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$resolveCase$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$refreshTrustedAdvisorCheck$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorChecks$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorCheckSummaries$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorCheckResult$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrustedAdvisorCheckRefreshStatuses$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSupportedLanguages$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSeverityLevels$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServices$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCreateCaseOptions$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCommunications$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCases$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAttachment$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCase$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addCommunicationToCase$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addAttachmentsToSet$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

