/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The statuses of the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorCheckRefreshStatuses</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustedAdvisorCheckRefreshStatusesResponse extends SupportResponse
        implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckRefreshStatusesResponse.Builder, DescribeTrustedAdvisorCheckRefreshStatusesResponse> {
    private static final SdkField<List<TrustedAdvisorCheckRefreshStatus>> STATUSES_FIELD = SdkField
            .<List<TrustedAdvisorCheckRefreshStatus>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTrustedAdvisorCheckRefreshStatusesResponse::statuses))
            .setter(setter(Builder::statuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrustedAdvisorCheckRefreshStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrustedAdvisorCheckRefreshStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUSES_FIELD));

    private final List<TrustedAdvisorCheckRefreshStatus> statuses;

    private DescribeTrustedAdvisorCheckRefreshStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.statuses = builder.statuses;
    }

    /**
     * <p>
     * The refresh status of the specified Trusted Advisor checks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The refresh status of the specified Trusted Advisor checks.
     */
    public List<TrustedAdvisorCheckRefreshStatus> statuses() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statuses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckRefreshStatusesResponse)) {
            return false;
        }
        DescribeTrustedAdvisorCheckRefreshStatusesResponse other = (DescribeTrustedAdvisorCheckRefreshStatusesResponse) obj;
        return Objects.equals(statuses(), other.statuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTrustedAdvisorCheckRefreshStatusesResponse").add("Statuses", statuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statuses":
            return Optional.ofNullable(clazz.cast(statuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorCheckRefreshStatusesResponse, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorCheckRefreshStatusesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrustedAdvisorCheckRefreshStatusesResponse> {
        /**
         * <p>
         * The refresh status of the specified Trusted Advisor checks.
         * </p>
         * 
         * @param statuses
         *        The refresh status of the specified Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<TrustedAdvisorCheckRefreshStatus> statuses);

        /**
         * <p>
         * The refresh status of the specified Trusted Advisor checks.
         * </p>
         * 
         * @param statuses
         *        The refresh status of the specified Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(TrustedAdvisorCheckRefreshStatus... statuses);

        /**
         * <p>
         * The refresh status of the specified Trusted Advisor checks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrustedAdvisorCheckRefreshStatus>.Builder}
         * avoiding the need to create one manually via {@link List<TrustedAdvisorCheckRefreshStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrustedAdvisorCheckRefreshStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #statuses(List<TrustedAdvisorCheckRefreshStatus>)}.
         * 
         * @param statuses
         *        a consumer that will call methods on {@link List<TrustedAdvisorCheckRefreshStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statuses(List<TrustedAdvisorCheckRefreshStatus>)
         */
        Builder statuses(Consumer<TrustedAdvisorCheckRefreshStatus.Builder>... statuses);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<TrustedAdvisorCheckRefreshStatus> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckRefreshStatusesResponse model) {
            super(model);
            statuses(model.statuses);
        }

        public final Collection<TrustedAdvisorCheckRefreshStatus.Builder> getStatuses() {
            return statuses != null ? statuses.stream().map(TrustedAdvisorCheckRefreshStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statuses(Collection<TrustedAdvisorCheckRefreshStatus> statuses) {
            this.statuses = TrustedAdvisorCheckRefreshStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(TrustedAdvisorCheckRefreshStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(Consumer<TrustedAdvisorCheckRefreshStatus.Builder>... statuses) {
            statuses(Stream.of(statuses).map(c -> TrustedAdvisorCheckRefreshStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStatuses(Collection<TrustedAdvisorCheckRefreshStatus.BuilderImpl> statuses) {
            this.statuses = TrustedAdvisorCheckRefreshStatusListCopier.copyFromBuilder(statuses);
        }

        @Override
        public DescribeTrustedAdvisorCheckRefreshStatusesResponse build() {
            return new DescribeTrustedAdvisorCheckRefreshStatusesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
