/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServicesRequest extends SupportRequest implements
        ToCopyableBuilder<DescribeServicesRequest.Builder, DescribeServicesRequest> {
    private static final SdkField<List<String>> SERVICE_CODE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeServicesRequest::serviceCodeList))
            .setter(setter(Builder::serviceCodeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCodeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeServicesRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_LIST_FIELD,
            LANGUAGE_FIELD));

    private final List<String> serviceCodeList;

    private final String language;

    private DescribeServicesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCodeList = builder.serviceCodeList;
        this.language = builder.language;
    }

    /**
     * <p>
     * A JSON-formatted list of service codes available for AWS services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A JSON-formatted list of service codes available for AWS services.
     */
    public List<String> serviceCodeList() {
        return serviceCodeList;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceCodeList());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesRequest)) {
            return false;
        }
        DescribeServicesRequest other = (DescribeServicesRequest) obj;
        return Objects.equals(serviceCodeList(), other.serviceCodeList()) && Objects.equals(language(), other.language());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeServicesRequest").add("ServiceCodeList", serviceCodeList()).add("Language", language())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceCodeList":
            return Optional.ofNullable(clazz.cast(serviceCodeList()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServicesRequest, T> g) {
        return obj -> g.apply((DescribeServicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServicesRequest> {
        /**
         * <p>
         * A JSON-formatted list of service codes available for AWS services.
         * </p>
         * 
         * @param serviceCodeList
         *        A JSON-formatted list of service codes available for AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodeList(Collection<String> serviceCodeList);

        /**
         * <p>
         * A JSON-formatted list of service codes available for AWS services.
         * </p>
         * 
         * @param serviceCodeList
         *        A JSON-formatted list of service codes available for AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodeList(String... serviceCodeList);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private List<String> serviceCodeList = DefaultSdkAutoConstructList.getInstance();

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesRequest model) {
            super(model);
            serviceCodeList(model.serviceCodeList);
            language(model.language);
        }

        public final Collection<String> getServiceCodeList() {
            return serviceCodeList;
        }

        @Override
        public final Builder serviceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodeList(String... serviceCodeList) {
            serviceCodeList(Arrays.asList(serviceCodeList));
            return this;
        }

        public final void setServiceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServicesRequest build() {
            return new DescribeServicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
