/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supportapp;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.supportapp.model.AccessDeniedException;
import software.amazon.awssdk.services.supportapp.model.ConflictException;
import software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.supportapp.model.DeleteAccountAliasRequest;
import software.amazon.awssdk.services.supportapp.model.DeleteAccountAliasResponse;
import software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest;
import software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationResponse;
import software.amazon.awssdk.services.supportapp.model.GetAccountAliasRequest;
import software.amazon.awssdk.services.supportapp.model.GetAccountAliasResponse;
import software.amazon.awssdk.services.supportapp.model.InternalServerException;
import software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse;
import software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest;
import software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse;
import software.amazon.awssdk.services.supportapp.model.PutAccountAliasRequest;
import software.amazon.awssdk.services.supportapp.model.PutAccountAliasResponse;
import software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest;
import software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse;
import software.amazon.awssdk.services.supportapp.model.ResourceNotFoundException;
import software.amazon.awssdk.services.supportapp.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.supportapp.model.SupportAppException;
import software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.supportapp.model.ValidationException;
import software.amazon.awssdk.services.supportapp.paginators.ListSlackChannelConfigurationsIterable;
import software.amazon.awssdk.services.supportapp.paginators.ListSlackWorkspaceConfigurationsIterable;

/**
 * Service client for accessing SupportApp. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <fullname>Amazon Web Services Support App in Slack</fullname>
 * <p>
 * You can use the Amazon Web Services Support App in Slack API to manage your support cases in Slack for your Amazon
 * Web Services account. After you configure your Slack workspace and channel with the Amazon Web Services Support App,
 * you can perform the following tasks directly in your Slack channel:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Create, search, update, and resolve your support cases
 * </p>
 * </li>
 * <li>
 * <p>
 * Request service quota increases for your account
 * </p>
 * </li>
 * <li>
 * <p>
 * Invite Amazon Web Services Support agents to your channel so that you can chat directly about your support cases
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information about how to perform these actions in Slack, see the following documentation in the <i>Amazon
 * Web Services Support User Guide</i>:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/awssupport/latest/user/aws-support-app-for-slack.html">Amazon Web Services
 * Support App in Slack</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/awssupport/latest/user/joining-a-live-chat-session.html">Joining a live chat
 * session with Amazon Web Services Support</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/awssupport/latest/user/service-quota-increase.html">Requesting service quota
 * increases</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/awssupport/latest/user/support-app-commands.html">Amazon Web Services Support
 * App commands in Slack</a>
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can also use the Amazon Web Services Management Console instead of the Amazon Web Services Support App API to
 * manage your Slack configurations. For more information, see <a
 * href="https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html">Authorize a Slack workspace
 * to enable the Amazon Web Services Support App</a>.
 * </p>
 * <note>
 * <ul>
 * <li>
 * <p>
 * You must have a Business or Enterprise Support plan to use the Amazon Web Services Support App API.
 * </p>
 * </li>
 * <li>
 * <p>
 * For more information about the Amazon Web Services Support App endpoints, see the <a
 * href="https://docs.aws.amazon.com/general/latest/gr/awssupport.html#awssupport_app_region">Amazon Web Services
 * Support App in Slack endpoints</a> in the <i>Amazon Web Services General Reference</i>.
 * </p>
 * </li>
 * </ul>
 * </note></p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SupportAppClient extends AwsClient {
    String SERVICE_NAME = "supportapp";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "supportapp";

    /**
     * <p>
     * Creates a Slack channel configuration for your Amazon Web Services account.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You can add up to 5 Slack workspaces for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can add up to 20 Slack channels for your account.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * A Slack channel can have up to 100 Amazon Web Services accounts. This means that only 100 accounts can add the
     * same Slack channel to the Amazon Web Services Support App. We recommend that you only add the accounts that you
     * need to manage support cases for your organization. This can reduce the notifications about case updates that you
     * receive in the Slack channel.
     * </p>
     * <note>
     * <p>
     * We recommend that you choose a private Slack channel so that only members in that channel have read and write
     * access to your support cases. Anyone in your Slack channel can create, update, or resolve support cases for your
     * account. Users require an invitation to join private channels.
     * </p>
     * </note>
     *
     * @param createSlackChannelConfigurationRequest
     * @return Result of the CreateSlackChannelConfiguration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Your Service Quotas request exceeds the quota for the service. For example, your Service Quotas request
     *         to Amazon Web Services Support App might exceed the maximum number of workspaces or channels per account,
     *         or the maximum number of accounts per Slack channel.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.CreateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/CreateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSlackChannelConfigurationResponse createSlackChannelConfiguration(
            CreateSlackChannelConfigurationRequest createSlackChannelConfigurationRequest) throws ServiceQuotaExceededException,
            ConflictException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Slack channel configuration for your Amazon Web Services account.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You can add up to 5 Slack workspaces for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can add up to 20 Slack channels for your account.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * A Slack channel can have up to 100 Amazon Web Services accounts. This means that only 100 accounts can add the
     * same Slack channel to the Amazon Web Services Support App. We recommend that you only add the accounts that you
     * need to manage support cases for your organization. This can reduce the notifications about case updates that you
     * receive in the Slack channel.
     * </p>
     * <note>
     * <p>
     * We recommend that you choose a private Slack channel so that only members in that channel have read and write
     * access to your support cases. Anyone in your Slack channel can create, update, or resolve support cases for your
     * account. Users require an invitation to join private channels.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param createSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSlackChannelConfiguration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Your Service Quotas request exceeds the quota for the service. For example, your Service Quotas request
     *         to Amazon Web Services Support App might exceed the maximum number of workspaces or channels per account,
     *         or the maximum number of accounts per Slack channel.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.CreateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/CreateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSlackChannelConfigurationResponse createSlackChannelConfiguration(
            Consumer<CreateSlackChannelConfigurationRequest.Builder> createSlackChannelConfigurationRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        return createSlackChannelConfiguration(CreateSlackChannelConfigurationRequest.builder()
                .applyMutation(createSlackChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an alias for an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App
     * page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web
     * Services Support App.
     * </p>
     *
     * @param deleteAccountAliasRequest
     * @return Result of the DeleteAccountAlias operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.DeleteAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteAccountAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountAliasResponse deleteAccountAlias(DeleteAccountAliasRequest deleteAccountAliasRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an alias for an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App
     * page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web
     * Services Support App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccountAliasRequest#builder()}
     * </p>
     *
     * @param deleteAccountAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.DeleteAccountAliasRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAccountAlias operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.DeleteAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteAccountAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountAliasResponse deleteAccountAlias(Consumer<DeleteAccountAliasRequest.Builder> deleteAccountAliasRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, SupportAppException {
        return deleteAccountAlias(DeleteAccountAliasRequest.builder().applyMutation(deleteAccountAliasRequest).build());
    }

    /**
     * <p>
     * Deletes a Slack channel configuration from your Amazon Web Services account. This operation doesn't delete your
     * Slack channel.
     * </p>
     *
     * @param deleteSlackChannelConfigurationRequest
     * @return Result of the DeleteSlackChannelConfiguration operation returned by the service.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.DeleteSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackChannelConfigurationResponse deleteSlackChannelConfiguration(
            DeleteSlackChannelConfigurationRequest deleteSlackChannelConfigurationRequest) throws ConflictException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Slack channel configuration from your Amazon Web Services account. This operation doesn't delete your
     * Slack channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteSlackChannelConfiguration operation returned by the service.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.DeleteSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackChannelConfigurationResponse deleteSlackChannelConfiguration(
            Consumer<DeleteSlackChannelConfigurationRequest.Builder> deleteSlackChannelConfigurationRequest)
            throws ConflictException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        return deleteSlackChannelConfiguration(DeleteSlackChannelConfigurationRequest.builder()
                .applyMutation(deleteSlackChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a Slack workspace configuration from your Amazon Web Services account. This operation doesn't delete your
     * Slack workspace.
     * </p>
     *
     * @param deleteSlackWorkspaceConfigurationRequest
     * @return Result of the DeleteSlackWorkspaceConfiguration operation returned by the service.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.DeleteSlackWorkspaceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteSlackWorkspaceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackWorkspaceConfigurationResponse deleteSlackWorkspaceConfiguration(
            DeleteSlackWorkspaceConfigurationRequest deleteSlackWorkspaceConfigurationRequest) throws ConflictException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Slack workspace configuration from your Amazon Web Services account. This operation doesn't delete your
     * Slack workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackWorkspaceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSlackWorkspaceConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSlackWorkspaceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteSlackWorkspaceConfiguration operation returned by the service.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.DeleteSlackWorkspaceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteSlackWorkspaceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackWorkspaceConfigurationResponse deleteSlackWorkspaceConfiguration(
            Consumer<DeleteSlackWorkspaceConfigurationRequest.Builder> deleteSlackWorkspaceConfigurationRequest)
            throws ConflictException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        return deleteSlackWorkspaceConfiguration(DeleteSlackWorkspaceConfigurationRequest.builder()
                .applyMutation(deleteSlackWorkspaceConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the alias from an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support
     * App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web
     * Services Support App.
     * </p>
     *
     * @param getAccountAliasRequest
     * @return Result of the GetAccountAlias operation returned by the service.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.GetAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/GetAccountAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountAliasResponse getAccountAlias(GetAccountAliasRequest getAccountAliasRequest)
            throws InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the alias from an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support
     * App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web
     * Services Support App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountAliasRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccountAliasRequest#builder()}
     * </p>
     *
     * @param getAccountAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.GetAccountAliasRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccountAlias operation returned by the service.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.GetAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/GetAccountAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountAliasResponse getAccountAlias(Consumer<GetAccountAliasRequest.Builder> getAccountAliasRequest)
            throws InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        return getAccountAlias(GetAccountAliasRequest.builder().applyMutation(getAccountAliasRequest).build());
    }

    /**
     * <p>
     * Lists the Slack channel configurations for an Amazon Web Services account.
     * </p>
     *
     * @param listSlackChannelConfigurationsRequest
     * @return Result of the ListSlackChannelConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.ListSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSlackChannelConfigurationsResponse listSlackChannelConfigurations(
            ListSlackChannelConfigurationsRequest listSlackChannelConfigurationsRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Slack channel configurations for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlackChannelConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSlackChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSlackChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListSlackChannelConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.ListSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSlackChannelConfigurationsResponse listSlackChannelConfigurations(
            Consumer<ListSlackChannelConfigurationsRequest.Builder> listSlackChannelConfigurationsRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        return listSlackChannelConfigurations(ListSlackChannelConfigurationsRequest.builder()
                .applyMutation(listSlackChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSlackChannelConfigurations(software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supportapp.paginators.ListSlackChannelConfigurationsIterable responses = client.listSlackChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supportapp.paginators.ListSlackChannelConfigurationsIterable responses = client
     *             .listSlackChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supportapp.paginators.ListSlackChannelConfigurationsIterable responses = client.listSlackChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlackChannelConfigurations(software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSlackChannelConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.ListSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSlackChannelConfigurationsIterable listSlackChannelConfigurationsPaginator(
            ListSlackChannelConfigurationsRequest listSlackChannelConfigurationsRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        return new ListSlackChannelConfigurationsIterable(this, listSlackChannelConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSlackChannelConfigurations(software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supportapp.paginators.ListSlackChannelConfigurationsIterable responses = client.listSlackChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supportapp.paginators.ListSlackChannelConfigurationsIterable responses = client
     *             .listSlackChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supportapp.paginators.ListSlackChannelConfigurationsIterable responses = client.listSlackChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlackChannelConfigurations(software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlackChannelConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSlackChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSlackChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.ListSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSlackChannelConfigurationsIterable listSlackChannelConfigurationsPaginator(
            Consumer<ListSlackChannelConfigurationsRequest.Builder> listSlackChannelConfigurationsRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        return listSlackChannelConfigurationsPaginator(ListSlackChannelConfigurationsRequest.builder()
                .applyMutation(listSlackChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the Slack workspace configurations for an Amazon Web Services account.
     * </p>
     *
     * @param listSlackWorkspaceConfigurationsRequest
     * @return Result of the ListSlackWorkspaceConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.ListSlackWorkspaceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackWorkspaceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSlackWorkspaceConfigurationsResponse listSlackWorkspaceConfigurations(
            ListSlackWorkspaceConfigurationsRequest listSlackWorkspaceConfigurationsRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Slack workspace configurations for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlackWorkspaceConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSlackWorkspaceConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSlackWorkspaceConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListSlackWorkspaceConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.ListSlackWorkspaceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackWorkspaceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSlackWorkspaceConfigurationsResponse listSlackWorkspaceConfigurations(
            Consumer<ListSlackWorkspaceConfigurationsRequest.Builder> listSlackWorkspaceConfigurationsRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        return listSlackWorkspaceConfigurations(ListSlackWorkspaceConfigurationsRequest.builder()
                .applyMutation(listSlackWorkspaceConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSlackWorkspaceConfigurations(software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supportapp.paginators.ListSlackWorkspaceConfigurationsIterable responses = client.listSlackWorkspaceConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supportapp.paginators.ListSlackWorkspaceConfigurationsIterable responses = client
     *             .listSlackWorkspaceConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supportapp.paginators.ListSlackWorkspaceConfigurationsIterable responses = client.listSlackWorkspaceConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlackWorkspaceConfigurations(software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSlackWorkspaceConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.ListSlackWorkspaceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackWorkspaceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSlackWorkspaceConfigurationsIterable listSlackWorkspaceConfigurationsPaginator(
            ListSlackWorkspaceConfigurationsRequest listSlackWorkspaceConfigurationsRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        return new ListSlackWorkspaceConfigurationsIterable(this, listSlackWorkspaceConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSlackWorkspaceConfigurations(software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supportapp.paginators.ListSlackWorkspaceConfigurationsIterable responses = client.listSlackWorkspaceConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.supportapp.paginators.ListSlackWorkspaceConfigurationsIterable responses = client
     *             .listSlackWorkspaceConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supportapp.paginators.ListSlackWorkspaceConfigurationsIterable responses = client.listSlackWorkspaceConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlackWorkspaceConfigurations(software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlackWorkspaceConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSlackWorkspaceConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSlackWorkspaceConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.ListSlackWorkspaceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackWorkspaceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSlackWorkspaceConfigurationsIterable listSlackWorkspaceConfigurationsPaginator(
            Consumer<ListSlackWorkspaceConfigurationsRequest.Builder> listSlackWorkspaceConfigurationsRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        return listSlackWorkspaceConfigurationsPaginator(ListSlackWorkspaceConfigurationsRequest.builder()
                .applyMutation(listSlackWorkspaceConfigurationsRequest).build());
    }

    /**
     * <p>
     * Creates or updates an individual alias for each Amazon Web Services account ID. The alias appears in the Amazon
     * Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages
     * from the Amazon Web Services Support App.
     * </p>
     *
     * @param putAccountAliasRequest
     * @return Result of the PutAccountAlias operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.PutAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/PutAccountAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default PutAccountAliasResponse putAccountAlias(PutAccountAliasRequest putAccountAliasRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an individual alias for each Amazon Web Services account ID. The alias appears in the Amazon
     * Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages
     * from the Amazon Web Services Support App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountAliasRequest.Builder} avoiding the need
     * to create one manually via {@link PutAccountAliasRequest#builder()}
     * </p>
     *
     * @param putAccountAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.PutAccountAliasRequest.Builder} to create a
     *        request.
     * @return Result of the PutAccountAlias operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.PutAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/PutAccountAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default PutAccountAliasResponse putAccountAlias(Consumer<PutAccountAliasRequest.Builder> putAccountAliasRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            SupportAppException {
        return putAccountAlias(PutAccountAliasRequest.builder().applyMutation(putAccountAliasRequest).build());
    }

    /**
     * <p>
     * Registers a Slack workspace for your Amazon Web Services account. To call this API, your account must be part of
     * an organization in Organizations.
     * </p>
     * <p>
     * If you're the <i>management account</i> and you want to register Slack workspaces for your organization, you must
     * complete the following tasks:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Sign in to the <a href="https://console.aws.amazon.com/support/app">Amazon Web Services Support Center</a> and
     * authorize the Slack workspaces where you want your organization to have access to. See <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html">Authorize a Slack
     * workspace</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call the <code>RegisterSlackWorkspaceForOrganization</code> API to authorize each Slack workspace for the
     * organization.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After the management account authorizes the Slack workspace, member accounts can call this API to authorize the
     * same Slack workspace for their individual accounts. Member accounts don't need to authorize the Slack workspace
     * manually through the <a href="https://console.aws.amazon.com/support/app">Amazon Web Services Support Center</a>.
     * </p>
     * <p>
     * To use the Amazon Web Services Support App, each account must then complete the following tasks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create an Identity and Access Management (IAM) role with the required permission. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html">Managing access to the
     * Amazon Web Services Support App</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Configure a Slack channel to use the Amazon Web Services Support App for support cases for that account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/add-your-slack-channel.html">Configuring a Slack
     * channel</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param registerSlackWorkspaceForOrganizationRequest
     * @return Result of the RegisterSlackWorkspaceForOrganization operation returned by the service.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.RegisterSlackWorkspaceForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/RegisterSlackWorkspaceForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterSlackWorkspaceForOrganizationResponse registerSlackWorkspaceForOrganization(
            RegisterSlackWorkspaceForOrganizationRequest registerSlackWorkspaceForOrganizationRequest) throws ConflictException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a Slack workspace for your Amazon Web Services account. To call this API, your account must be part of
     * an organization in Organizations.
     * </p>
     * <p>
     * If you're the <i>management account</i> and you want to register Slack workspaces for your organization, you must
     * complete the following tasks:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Sign in to the <a href="https://console.aws.amazon.com/support/app">Amazon Web Services Support Center</a> and
     * authorize the Slack workspaces where you want your organization to have access to. See <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html">Authorize a Slack
     * workspace</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call the <code>RegisterSlackWorkspaceForOrganization</code> API to authorize each Slack workspace for the
     * organization.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After the management account authorizes the Slack workspace, member accounts can call this API to authorize the
     * same Slack workspace for their individual accounts. Member accounts don't need to authorize the Slack workspace
     * manually through the <a href="https://console.aws.amazon.com/support/app">Amazon Web Services Support Center</a>.
     * </p>
     * <p>
     * To use the Amazon Web Services Support App, each account must then complete the following tasks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create an Identity and Access Management (IAM) role with the required permission. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html">Managing access to the
     * Amazon Web Services Support App</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Configure a Slack channel to use the Amazon Web Services Support App for support cases for that account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/add-your-slack-channel.html">Configuring a Slack
     * channel</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link RegisterSlackWorkspaceForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link RegisterSlackWorkspaceForOrganizationRequest#builder()}
     * </p>
     *
     * @param registerSlackWorkspaceForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the RegisterSlackWorkspaceForOrganization operation returned by the service.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.RegisterSlackWorkspaceForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/RegisterSlackWorkspaceForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterSlackWorkspaceForOrganizationResponse registerSlackWorkspaceForOrganization(
            Consumer<RegisterSlackWorkspaceForOrganizationRequest.Builder> registerSlackWorkspaceForOrganizationRequest)
            throws ConflictException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        return registerSlackWorkspaceForOrganization(RegisterSlackWorkspaceForOrganizationRequest.builder()
                .applyMutation(registerSlackWorkspaceForOrganizationRequest).build());
    }

    /**
     * <p>
     * Updates the configuration for a Slack channel, such as case update notifications.
     * </p>
     *
     * @param updateSlackChannelConfigurationRequest
     * @return Result of the UpdateSlackChannelConfiguration operation returned by the service.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.UpdateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/UpdateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSlackChannelConfigurationResponse updateSlackChannelConfiguration(
            UpdateSlackChannelConfigurationRequest updateSlackChannelConfigurationRequest) throws ConflictException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, SupportAppException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for a Slack channel, such as case update notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSlackChannelConfiguration operation returned by the service.
     * @throws ConflictException
     *         Your request has a conflict. For example, you might receive this error if you try the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add, update, or delete a Slack channel configuration before you add a Slack workspace to your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add a Slack channel configuration that already exists in your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack channel configuration for a live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delete a Slack workspace from your Amazon Web Services account that has an active live chat channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from an Amazon Web Services account that
     *         doesn't belong to an organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Call the <code>RegisterSlackWorkspaceForOrganization</code> API from a member account, but the management
     *         account hasn't registered that workspace yet for the organization.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         The specified resource is missing or doesn't exist, such as an account alias, Slack channel
     *         configuration, or Slack workspace configuration.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws InternalServerException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ValidationException
     *         Your request input doesn't meet the constraints that the Amazon Web Services Support App specifies.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SupportAppException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SupportAppClient.UpdateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/UpdateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSlackChannelConfigurationResponse updateSlackChannelConfiguration(
            Consumer<UpdateSlackChannelConfigurationRequest.Builder> updateSlackChannelConfigurationRequest)
            throws ConflictException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        return updateSlackChannelConfiguration(UpdateSlackChannelConfigurationRequest.builder()
                .applyMutation(updateSlackChannelConfigurationRequest).build());
    }

    /**
     * Create a {@link SupportAppClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SupportAppClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SupportAppClient}.
     */
    static SupportAppClientBuilder builder() {
        return new DefaultSupportAppClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SupportAppServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
