/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supportapp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSlackWorkspaceConfigurationsResponse extends SupportAppResponse implements
        ToCopyableBuilder<ListSlackWorkspaceConfigurationsResponse.Builder, ListSlackWorkspaceConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSlackWorkspaceConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SlackWorkspaceConfiguration>> SLACK_WORKSPACE_CONFIGURATIONS_FIELD = SdkField
            .<List<SlackWorkspaceConfiguration>> builder(MarshallingType.LIST)
            .memberName("slackWorkspaceConfigurations")
            .getter(getter(ListSlackWorkspaceConfigurationsResponse::slackWorkspaceConfigurations))
            .setter(setter(Builder::slackWorkspaceConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slackWorkspaceConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlackWorkspaceConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlackWorkspaceConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SLACK_WORKSPACE_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<SlackWorkspaceConfiguration> slackWorkspaceConfigurations;

    private ListSlackWorkspaceConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.slackWorkspaceConfigurations = builder.slackWorkspaceConfigurations;
    }

    /**
     * <p>
     * The point where pagination should resume when the response returns only partial results.
     * </p>
     * 
     * @return The point where pagination should resume when the response returns only partial results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlackWorkspaceConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSlackWorkspaceConfigurations() {
        return slackWorkspaceConfigurations != null && !(slackWorkspaceConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configurations for a Slack workspace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlackWorkspaceConfigurations} method.
     * </p>
     * 
     * @return The configurations for a Slack workspace.
     */
    public final List<SlackWorkspaceConfiguration> slackWorkspaceConfigurations() {
        return slackWorkspaceConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlackWorkspaceConfigurations() ? slackWorkspaceConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSlackWorkspaceConfigurationsResponse)) {
            return false;
        }
        ListSlackWorkspaceConfigurationsResponse other = (ListSlackWorkspaceConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasSlackWorkspaceConfigurations() == other.hasSlackWorkspaceConfigurations()
                && Objects.equals(slackWorkspaceConfigurations(), other.slackWorkspaceConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSlackWorkspaceConfigurationsResponse").add("NextToken", nextToken())
                .add("SlackWorkspaceConfigurations", hasSlackWorkspaceConfigurations() ? slackWorkspaceConfigurations() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "slackWorkspaceConfigurations":
            return Optional.ofNullable(clazz.cast(slackWorkspaceConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("slackWorkspaceConfigurations", SLACK_WORKSPACE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSlackWorkspaceConfigurationsResponse, T> g) {
        return obj -> g.apply((ListSlackWorkspaceConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportAppResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSlackWorkspaceConfigurationsResponse> {
        /**
         * <p>
         * The point where pagination should resume when the response returns only partial results.
         * </p>
         * 
         * @param nextToken
         *        The point where pagination should resume when the response returns only partial results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The configurations for a Slack workspace.
         * </p>
         * 
         * @param slackWorkspaceConfigurations
         *        The configurations for a Slack workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackWorkspaceConfigurations(Collection<SlackWorkspaceConfiguration> slackWorkspaceConfigurations);

        /**
         * <p>
         * The configurations for a Slack workspace.
         * </p>
         * 
         * @param slackWorkspaceConfigurations
         *        The configurations for a Slack workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackWorkspaceConfigurations(SlackWorkspaceConfiguration... slackWorkspaceConfigurations);

        /**
         * <p>
         * The configurations for a Slack workspace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #slackWorkspaceConfigurations(List<SlackWorkspaceConfiguration>)}.
         * 
         * @param slackWorkspaceConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slackWorkspaceConfigurations(java.util.Collection<SlackWorkspaceConfiguration>)
         */
        Builder slackWorkspaceConfigurations(Consumer<SlackWorkspaceConfiguration.Builder>... slackWorkspaceConfigurations);
    }

    static final class BuilderImpl extends SupportAppResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SlackWorkspaceConfiguration> slackWorkspaceConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSlackWorkspaceConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            slackWorkspaceConfigurations(model.slackWorkspaceConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SlackWorkspaceConfiguration.Builder> getSlackWorkspaceConfigurations() {
            List<SlackWorkspaceConfiguration.Builder> result = SlackWorkspaceConfigurationListCopier
                    .copyToBuilder(this.slackWorkspaceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlackWorkspaceConfigurations(
                Collection<SlackWorkspaceConfiguration.BuilderImpl> slackWorkspaceConfigurations) {
            this.slackWorkspaceConfigurations = SlackWorkspaceConfigurationListCopier
                    .copyFromBuilder(slackWorkspaceConfigurations);
        }

        @Override
        public final Builder slackWorkspaceConfigurations(Collection<SlackWorkspaceConfiguration> slackWorkspaceConfigurations) {
            this.slackWorkspaceConfigurations = SlackWorkspaceConfigurationListCopier.copy(slackWorkspaceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackWorkspaceConfigurations(SlackWorkspaceConfiguration... slackWorkspaceConfigurations) {
            slackWorkspaceConfigurations(Arrays.asList(slackWorkspaceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackWorkspaceConfigurations(
                Consumer<SlackWorkspaceConfiguration.Builder>... slackWorkspaceConfigurations) {
            slackWorkspaceConfigurations(Stream.of(slackWorkspaceConfigurations)
                    .map(c -> SlackWorkspaceConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSlackWorkspaceConfigurationsResponse build() {
            return new ListSlackWorkspaceConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
