/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supportapp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterSlackWorkspaceForOrganizationResponse extends SupportAppResponse implements
        ToCopyableBuilder<RegisterSlackWorkspaceForOrganizationResponse.Builder, RegisterSlackWorkspaceForOrganizationResponse> {
    private static final SdkField<String> ACCOUNT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountType").getter(getter(RegisterSlackWorkspaceForOrganizationResponse::accountTypeAsString))
            .setter(setter(Builder::accountType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountType").build()).build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("teamId")
            .getter(getter(RegisterSlackWorkspaceForOrganizationResponse::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teamId").build()).build();

    private static final SdkField<String> TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("teamName").getter(getter(RegisterSlackWorkspaceForOrganizationResponse::teamName))
            .setter(setter(Builder::teamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_TYPE_FIELD,
            TEAM_ID_FIELD, TEAM_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountType;

    private final String teamId;

    private final String teamName;

    private RegisterSlackWorkspaceForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.accountType = builder.accountType;
        this.teamId = builder.teamId;
        this.teamName = builder.teamName;
    }

    /**
     * <p>
     * Whether the Amazon Web Services account is a management or member account that's part of an organization in
     * Organizations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountType} will
     * return {@link AccountType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountTypeAsString}.
     * </p>
     * 
     * @return Whether the Amazon Web Services account is a management or member account that's part of an organization
     *         in Organizations.
     * @see AccountType
     */
    public final AccountType accountType() {
        return AccountType.fromValue(accountType);
    }

    /**
     * <p>
     * Whether the Amazon Web Services account is a management or member account that's part of an organization in
     * Organizations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountType} will
     * return {@link AccountType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountTypeAsString}.
     * </p>
     * 
     * @return Whether the Amazon Web Services account is a management or member account that's part of an organization
     *         in Organizations.
     * @see AccountType
     */
    public final String accountTypeAsString() {
        return accountType;
    }

    /**
     * <p>
     * The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
     * </p>
     * 
     * @return The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
     */
    public final String teamId() {
        return teamId;
    }

    /**
     * <p>
     * The name of the Slack workspace.
     * </p>
     * 
     * @return The name of the Slack workspace.
     */
    public final String teamName() {
        return teamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        hashCode = 31 * hashCode + Objects.hashCode(teamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterSlackWorkspaceForOrganizationResponse)) {
            return false;
        }
        RegisterSlackWorkspaceForOrganizationResponse other = (RegisterSlackWorkspaceForOrganizationResponse) obj;
        return Objects.equals(accountTypeAsString(), other.accountTypeAsString()) && Objects.equals(teamId(), other.teamId())
                && Objects.equals(teamName(), other.teamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterSlackWorkspaceForOrganizationResponse").add("AccountType", accountTypeAsString())
                .add("TeamId", teamId()).add("TeamName", teamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountType":
            return Optional.ofNullable(clazz.cast(accountTypeAsString()));
        case "teamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        case "teamName":
            return Optional.ofNullable(clazz.cast(teamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountType", ACCOUNT_TYPE_FIELD);
        map.put("teamId", TEAM_ID_FIELD);
        map.put("teamName", TEAM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterSlackWorkspaceForOrganizationResponse, T> g) {
        return obj -> g.apply((RegisterSlackWorkspaceForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportAppResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterSlackWorkspaceForOrganizationResponse> {
        /**
         * <p>
         * Whether the Amazon Web Services account is a management or member account that's part of an organization in
         * Organizations.
         * </p>
         * 
         * @param accountType
         *        Whether the Amazon Web Services account is a management or member account that's part of an
         *        organization in Organizations.
         * @see AccountType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountType
         */
        Builder accountType(String accountType);

        /**
         * <p>
         * Whether the Amazon Web Services account is a management or member account that's part of an organization in
         * Organizations.
         * </p>
         * 
         * @param accountType
         *        Whether the Amazon Web Services account is a management or member account that's part of an
         *        organization in Organizations.
         * @see AccountType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountType
         */
        Builder accountType(AccountType accountType);

        /**
         * <p>
         * The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
         * </p>
         * 
         * @param teamId
         *        The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        /**
         * <p>
         * The name of the Slack workspace.
         * </p>
         * 
         * @param teamName
         *        The name of the Slack workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamName(String teamName);
    }

    static final class BuilderImpl extends SupportAppResponse.BuilderImpl implements Builder {
        private String accountType;

        private String teamId;

        private String teamName;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterSlackWorkspaceForOrganizationResponse model) {
            super(model);
            accountType(model.accountType);
            teamId(model.teamId);
            teamName(model.teamName);
        }

        public final String getAccountType() {
            return accountType;
        }

        public final void setAccountType(String accountType) {
            this.accountType = accountType;
        }

        @Override
        public final Builder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        @Override
        public final Builder accountType(AccountType accountType) {
            this.accountType(accountType == null ? null : accountType.toString());
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getTeamName() {
            return teamName;
        }

        public final void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Override
        public final Builder teamName(String teamName) {
            this.teamName = teamName;
            return this;
        }

        @Override
        public RegisterSlackWorkspaceForOrganizationResponse build() {
            return new RegisterSlackWorkspaceForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
