/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supportapp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a Slack workspace that you added to an Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlackWorkspaceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SlackWorkspaceConfiguration.Builder, SlackWorkspaceConfiguration> {
    private static final SdkField<Boolean> ALLOW_ORGANIZATION_MEMBER_ACCOUNT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowOrganizationMemberAccount")
            .getter(getter(SlackWorkspaceConfiguration::allowOrganizationMemberAccount))
            .setter(setter(Builder::allowOrganizationMemberAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowOrganizationMemberAccount")
                    .build()).build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("teamId")
            .getter(getter(SlackWorkspaceConfiguration::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teamId").build()).build();

    private static final SdkField<String> TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("teamName").getter(getter(SlackWorkspaceConfiguration::teamName)).setter(setter(Builder::teamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOW_ORGANIZATION_MEMBER_ACCOUNT_FIELD, TEAM_ID_FIELD, TEAM_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean allowOrganizationMemberAccount;

    private final String teamId;

    private final String teamName;

    private SlackWorkspaceConfiguration(BuilderImpl builder) {
        this.allowOrganizationMemberAccount = builder.allowOrganizationMemberAccount;
        this.teamId = builder.teamId;
        this.teamName = builder.teamName;
    }

    /**
     * <p>
     * Whether to allow member accounts to authorize Slack workspaces. Member accounts must be part of an organization
     * in Organizations.
     * </p>
     * 
     * @return Whether to allow member accounts to authorize Slack workspaces. Member accounts must be part of an
     *         organization in Organizations.
     */
    public final Boolean allowOrganizationMemberAccount() {
        return allowOrganizationMemberAccount;
    }

    /**
     * <p>
     * The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
     * </p>
     * 
     * @return The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
     */
    public final String teamId() {
        return teamId;
    }

    /**
     * <p>
     * The name of the Slack workspace.
     * </p>
     * 
     * @return The name of the Slack workspace.
     */
    public final String teamName() {
        return teamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowOrganizationMemberAccount());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        hashCode = 31 * hashCode + Objects.hashCode(teamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlackWorkspaceConfiguration)) {
            return false;
        }
        SlackWorkspaceConfiguration other = (SlackWorkspaceConfiguration) obj;
        return Objects.equals(allowOrganizationMemberAccount(), other.allowOrganizationMemberAccount())
                && Objects.equals(teamId(), other.teamId()) && Objects.equals(teamName(), other.teamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlackWorkspaceConfiguration")
                .add("AllowOrganizationMemberAccount", allowOrganizationMemberAccount()).add("TeamId", teamId())
                .add("TeamName", teamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowOrganizationMemberAccount":
            return Optional.ofNullable(clazz.cast(allowOrganizationMemberAccount()));
        case "teamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        case "teamName":
            return Optional.ofNullable(clazz.cast(teamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowOrganizationMemberAccount", ALLOW_ORGANIZATION_MEMBER_ACCOUNT_FIELD);
        map.put("teamId", TEAM_ID_FIELD);
        map.put("teamName", TEAM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlackWorkspaceConfiguration, T> g) {
        return obj -> g.apply((SlackWorkspaceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlackWorkspaceConfiguration> {
        /**
         * <p>
         * Whether to allow member accounts to authorize Slack workspaces. Member accounts must be part of an
         * organization in Organizations.
         * </p>
         * 
         * @param allowOrganizationMemberAccount
         *        Whether to allow member accounts to authorize Slack workspaces. Member accounts must be part of an
         *        organization in Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOrganizationMemberAccount(Boolean allowOrganizationMemberAccount);

        /**
         * <p>
         * The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
         * </p>
         * 
         * @param teamId
         *        The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        /**
         * <p>
         * The name of the Slack workspace.
         * </p>
         * 
         * @param teamName
         *        The name of the Slack workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamName(String teamName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowOrganizationMemberAccount;

        private String teamId;

        private String teamName;

        private BuilderImpl() {
        }

        private BuilderImpl(SlackWorkspaceConfiguration model) {
            allowOrganizationMemberAccount(model.allowOrganizationMemberAccount);
            teamId(model.teamId);
            teamName(model.teamName);
        }

        public final Boolean getAllowOrganizationMemberAccount() {
            return allowOrganizationMemberAccount;
        }

        public final void setAllowOrganizationMemberAccount(Boolean allowOrganizationMemberAccount) {
            this.allowOrganizationMemberAccount = allowOrganizationMemberAccount;
        }

        @Override
        public final Builder allowOrganizationMemberAccount(Boolean allowOrganizationMemberAccount) {
            this.allowOrganizationMemberAccount = allowOrganizationMemberAccount;
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getTeamName() {
            return teamName;
        }

        public final void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Override
        public final Builder teamName(String teamName) {
            this.teamName = teamName;
            return this;
        }

        @Override
        public SlackWorkspaceConfiguration build() {
            return new SlackWorkspaceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
