/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>DecisionTaskTimedOut</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecisionTaskTimedOutEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DecisionTaskTimedOutEventAttributes.Builder, DecisionTaskTimedOutEventAttributes> {
    private static final SdkField<String> TIMEOUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DecisionTaskTimedOutEventAttributes::timeoutTypeAsString)).setter(setter(Builder::timeoutType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutType").build()).build();

    private static final SdkField<Long> SCHEDULED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DecisionTaskTimedOutEventAttributes::scheduledEventId)).setter(setter(Builder::scheduledEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledEventId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DecisionTaskTimedOutEventAttributes::startedEventId)).setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_TYPE_FIELD,
            SCHEDULED_EVENT_ID_FIELD, STARTED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeoutType;

    private final Long scheduledEventId;

    private final Long startedEventId;

    private DecisionTaskTimedOutEventAttributes(BuilderImpl builder) {
        this.timeoutType = builder.timeoutType;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
    }

    /**
     * <p>
     * The type of timeout that expired before the decision task could be completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeoutType} will
     * return {@link DecisionTaskTimeoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeoutTypeAsString}.
     * </p>
     * 
     * @return The type of timeout that expired before the decision task could be completed.
     * @see DecisionTaskTimeoutType
     */
    public DecisionTaskTimeoutType timeoutType() {
        return DecisionTaskTimeoutType.fromValue(timeoutType);
    }

    /**
     * <p>
     * The type of timeout that expired before the decision task could be completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeoutType} will
     * return {@link DecisionTaskTimeoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeoutTypeAsString}.
     * </p>
     * 
     * @return The type of timeout that expired before the decision task could be completed.
     * @see DecisionTaskTimeoutType
     */
    public String timeoutTypeAsString() {
        return timeoutType;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was
     *         scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledEventId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecisionTaskTimedOutEventAttributes)) {
            return false;
        }
        DecisionTaskTimedOutEventAttributes other = (DecisionTaskTimedOutEventAttributes) obj;
        return Objects.equals(timeoutTypeAsString(), other.timeoutTypeAsString())
                && Objects.equals(scheduledEventId(), other.scheduledEventId())
                && Objects.equals(startedEventId(), other.startedEventId());
    }

    @Override
    public String toString() {
        return ToString.builder("DecisionTaskTimedOutEventAttributes").add("TimeoutType", timeoutTypeAsString())
                .add("ScheduledEventId", scheduledEventId()).add("StartedEventId", startedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutType":
            return Optional.ofNullable(clazz.cast(timeoutTypeAsString()));
        case "scheduledEventId":
            return Optional.ofNullable(clazz.cast(scheduledEventId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecisionTaskTimedOutEventAttributes, T> g) {
        return obj -> g.apply((DecisionTaskTimedOutEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecisionTaskTimedOutEventAttributes> {
        /**
         * <p>
         * The type of timeout that expired before the decision task could be completed.
         * </p>
         * 
         * @param timeoutType
         *        The type of timeout that expired before the decision task could be completed.
         * @see DecisionTaskTimeoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecisionTaskTimeoutType
         */
        Builder timeoutType(String timeoutType);

        /**
         * <p>
         * The type of timeout that expired before the decision task could be completed.
         * </p>
         * 
         * @param timeoutType
         *        The type of timeout that expired before the decision task could be completed.
         * @see DecisionTaskTimeoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecisionTaskTimeoutType
         */
        Builder timeoutType(DecisionTaskTimeoutType timeoutType);

        /**
         * <p>
         * The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was
         *        scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started.
         *        This information can be useful for diagnosing problems by tracing back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String timeoutType;

        private Long scheduledEventId;

        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(DecisionTaskTimedOutEventAttributes model) {
            timeoutType(model.timeoutType);
            scheduledEventId(model.scheduledEventId);
            startedEventId(model.startedEventId);
        }

        public final String getTimeoutType() {
            return timeoutType;
        }

        @Override
        public final Builder timeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
            return this;
        }

        @Override
        public final Builder timeoutType(DecisionTaskTimeoutType timeoutType) {
            this.timeoutType(timeoutType.toString());
            return this;
        }

        public final void setTimeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public DecisionTaskTimedOutEventAttributes build() {
            return new DecisionTaskTimedOutEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
