/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an activity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeActivityTypeResponse extends SwfResponse implements
        ToCopyableBuilder<DescribeActivityTypeResponse.Builder, DescribeActivityTypeResponse> {
    private static final SdkField<ActivityTypeInfo> TYPE_INFO_FIELD = SdkField
            .<ActivityTypeInfo> builder(MarshallingType.SDK_POJO).getter(getter(DescribeActivityTypeResponse::typeInfo))
            .setter(setter(Builder::typeInfo)).constructor(ActivityTypeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeInfo").build()).build();

    private static final SdkField<ActivityTypeConfiguration> CONFIGURATION_FIELD = SdkField
            .<ActivityTypeConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeActivityTypeResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(ActivityTypeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_INFO_FIELD,
            CONFIGURATION_FIELD));

    private final ActivityTypeInfo typeInfo;

    private final ActivityTypeConfiguration configuration;

    private DescribeActivityTypeResponse(BuilderImpl builder) {
        super(builder);
        this.typeInfo = builder.typeInfo;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * General information about the activity type.
     * </p>
     * <p>
     * The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateActivityType</a>, but is still in use. You
     * should keep workers supporting this type running. You cannot create new tasks of this type.
     * </p>
     * </li>
     * </ul>
     * 
     * @return General information about the activity type.</p>
     *         <p>
     *         The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be
     *         running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateActivityType</a>, but is still in
     *         use. You should keep workers supporting this type running. You cannot create new tasks of this type.
     *         </p>
     *         </li>
     */
    public ActivityTypeInfo typeInfo() {
        return typeInfo;
    }

    /**
     * <p>
     * The configuration settings registered with the activity type.
     * </p>
     * 
     * @return The configuration settings registered with the activity type.
     */
    public ActivityTypeConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivityTypeResponse)) {
            return false;
        }
        DescribeActivityTypeResponse other = (DescribeActivityTypeResponse) obj;
        return Objects.equals(typeInfo(), other.typeInfo()) && Objects.equals(configuration(), other.configuration());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeActivityTypeResponse").add("TypeInfo", typeInfo()).add("Configuration", configuration())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "typeInfo":
            return Optional.ofNullable(clazz.cast(typeInfo()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivityTypeResponse, T> g) {
        return obj -> g.apply((DescribeActivityTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeActivityTypeResponse> {
        /**
         * <p>
         * General information about the activity type.
         * </p>
         * <p>
         * The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be
         * running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateActivityType</a>, but is still in use.
         * You should keep workers supporting this type running. You cannot create new tasks of this type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param typeInfo
         *        General information about the activity type.</p>
         *        <p>
         *        The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be
         *        running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateActivityType</a>, but is still in
         *        use. You should keep workers supporting this type running. You cannot create new tasks of this type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeInfo(ActivityTypeInfo typeInfo);

        /**
         * <p>
         * General information about the activity type.
         * </p>
         * <p>
         * The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be
         * running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateActivityType</a>, but is still in use.
         * You should keep workers supporting this type running. You cannot create new tasks of this type.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link ActivityTypeInfo.Builder} avoiding the need to
         * create one manually via {@link ActivityTypeInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityTypeInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #typeInfo(ActivityTypeInfo)}.
         * 
         * @param typeInfo
         *        a consumer that will call methods on {@link ActivityTypeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeInfo(ActivityTypeInfo)
         */
        default Builder typeInfo(Consumer<ActivityTypeInfo.Builder> typeInfo) {
            return typeInfo(ActivityTypeInfo.builder().applyMutation(typeInfo).build());
        }

        /**
         * <p>
         * The configuration settings registered with the activity type.
         * </p>
         * 
         * @param configuration
         *        The configuration settings registered with the activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ActivityTypeConfiguration configuration);

        /**
         * <p>
         * The configuration settings registered with the activity type.
         * </p>
         * This is a convenience that creates an instance of the {@link ActivityTypeConfiguration.Builder} avoiding the
         * need to create one manually via {@link ActivityTypeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityTypeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(ActivityTypeConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ActivityTypeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ActivityTypeConfiguration)
         */
        default Builder configuration(Consumer<ActivityTypeConfiguration.Builder> configuration) {
            return configuration(ActivityTypeConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private ActivityTypeInfo typeInfo;

        private ActivityTypeConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivityTypeResponse model) {
            super(model);
            typeInfo(model.typeInfo);
            configuration(model.configuration);
        }

        public final ActivityTypeInfo.Builder getTypeInfo() {
            return typeInfo != null ? typeInfo.toBuilder() : null;
        }

        @Override
        public final Builder typeInfo(ActivityTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            return this;
        }

        public final void setTypeInfo(ActivityTypeInfo.BuilderImpl typeInfo) {
            this.typeInfo = typeInfo != null ? typeInfo.build() : null;
        }

        public final ActivityTypeConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ActivityTypeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ActivityTypeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public DescribeActivityTypeResponse build() {
            return new DescribeActivityTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
