/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkflowExecutionResponse extends SwfResponse implements
        ToCopyableBuilder<DescribeWorkflowExecutionResponse.Builder, DescribeWorkflowExecutionResponse> {
    private static final SdkField<WorkflowExecutionInfo> EXECUTION_INFO_FIELD = SdkField
            .<WorkflowExecutionInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeWorkflowExecutionResponse::executionInfo)).setter(setter(Builder::executionInfo))
            .constructor(WorkflowExecutionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionInfo").build()).build();

    private static final SdkField<WorkflowExecutionConfiguration> EXECUTION_CONFIGURATION_FIELD = SdkField
            .<WorkflowExecutionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeWorkflowExecutionResponse::executionConfiguration))
            .setter(setter(Builder::executionConfiguration)).constructor(WorkflowExecutionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionConfiguration").build())
            .build();

    private static final SdkField<WorkflowExecutionOpenCounts> OPEN_COUNTS_FIELD = SdkField
            .<WorkflowExecutionOpenCounts> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeWorkflowExecutionResponse::openCounts)).setter(setter(Builder::openCounts))
            .constructor(WorkflowExecutionOpenCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openCounts").build()).build();

    private static final SdkField<Instant> LATEST_ACTIVITY_TASK_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeWorkflowExecutionResponse::latestActivityTaskTimestamp))
            .setter(setter(Builder::latestActivityTaskTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestActivityTaskTimestamp")
                    .build()).build();

    private static final SdkField<String> LATEST_EXECUTION_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeWorkflowExecutionResponse::latestExecutionContext))
            .setter(setter(Builder::latestExecutionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecutionContext").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_INFO_FIELD,
            EXECUTION_CONFIGURATION_FIELD, OPEN_COUNTS_FIELD, LATEST_ACTIVITY_TASK_TIMESTAMP_FIELD,
            LATEST_EXECUTION_CONTEXT_FIELD));

    private final WorkflowExecutionInfo executionInfo;

    private final WorkflowExecutionConfiguration executionConfiguration;

    private final WorkflowExecutionOpenCounts openCounts;

    private final Instant latestActivityTaskTimestamp;

    private final String latestExecutionContext;

    private DescribeWorkflowExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionInfo = builder.executionInfo;
        this.executionConfiguration = builder.executionConfiguration;
        this.openCounts = builder.openCounts;
        this.latestActivityTaskTimestamp = builder.latestActivityTaskTimestamp;
        this.latestExecutionContext = builder.latestExecutionContext;
    }

    /**
     * <p>
     * Information about the workflow execution.
     * </p>
     * 
     * @return Information about the workflow execution.
     */
    public WorkflowExecutionInfo executionInfo() {
        return executionInfo;
    }

    /**
     * <p>
     * The configuration settings for this workflow execution including timeout values, tasklist etc.
     * </p>
     * 
     * @return The configuration settings for this workflow execution including timeout values, tasklist etc.
     */
    public WorkflowExecutionConfiguration executionConfiguration() {
        return executionConfiguration;
    }

    /**
     * <p>
     * The number of tasks for this workflow execution. This includes open and closed tasks of all types.
     * </p>
     * 
     * @return The number of tasks for this workflow execution. This includes open and closed tasks of all types.
     */
    public WorkflowExecutionOpenCounts openCounts() {
        return openCounts;
    }

    /**
     * <p>
     * The time when the last activity task was scheduled for this workflow execution. You can use this information to
     * determine if the workflow has not made progress for an unusually long period of time and might require a
     * corrective action.
     * </p>
     * 
     * @return The time when the last activity task was scheduled for this workflow execution. You can use this
     *         information to determine if the workflow has not made progress for an unusually long period of time and
     *         might require a corrective action.
     */
    public Instant latestActivityTaskTimestamp() {
        return latestActivityTaskTimestamp;
    }

    /**
     * <p>
     * The latest executionContext provided by the decider for this workflow execution. A decider can provide an
     * executionContext (a free-form string) when closing a decision task using <a>RespondDecisionTaskCompleted</a>.
     * </p>
     * 
     * @return The latest executionContext provided by the decider for this workflow execution. A decider can provide an
     *         executionContext (a free-form string) when closing a decision task using
     *         <a>RespondDecisionTaskCompleted</a>.
     */
    public String latestExecutionContext() {
        return latestExecutionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(executionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(openCounts());
        hashCode = 31 * hashCode + Objects.hashCode(latestActivityTaskTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(latestExecutionContext());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowExecutionResponse)) {
            return false;
        }
        DescribeWorkflowExecutionResponse other = (DescribeWorkflowExecutionResponse) obj;
        return Objects.equals(executionInfo(), other.executionInfo())
                && Objects.equals(executionConfiguration(), other.executionConfiguration())
                && Objects.equals(openCounts(), other.openCounts())
                && Objects.equals(latestActivityTaskTimestamp(), other.latestActivityTaskTimestamp())
                && Objects.equals(latestExecutionContext(), other.latestExecutionContext());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeWorkflowExecutionResponse").add("ExecutionInfo", executionInfo())
                .add("ExecutionConfiguration", executionConfiguration()).add("OpenCounts", openCounts())
                .add("LatestActivityTaskTimestamp", latestActivityTaskTimestamp())
                .add("LatestExecutionContext", latestExecutionContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionInfo":
            return Optional.ofNullable(clazz.cast(executionInfo()));
        case "executionConfiguration":
            return Optional.ofNullable(clazz.cast(executionConfiguration()));
        case "openCounts":
            return Optional.ofNullable(clazz.cast(openCounts()));
        case "latestActivityTaskTimestamp":
            return Optional.ofNullable(clazz.cast(latestActivityTaskTimestamp()));
        case "latestExecutionContext":
            return Optional.ofNullable(clazz.cast(latestExecutionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkflowExecutionResponse, T> g) {
        return obj -> g.apply((DescribeWorkflowExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkflowExecutionResponse> {
        /**
         * <p>
         * Information about the workflow execution.
         * </p>
         * 
         * @param executionInfo
         *        Information about the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfo(WorkflowExecutionInfo executionInfo);

        /**
         * <p>
         * Information about the workflow execution.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecutionInfo.Builder} avoiding the need
         * to create one manually via {@link WorkflowExecutionInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecutionInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #executionInfo(WorkflowExecutionInfo)}.
         * 
         * @param executionInfo
         *        a consumer that will call methods on {@link WorkflowExecutionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionInfo(WorkflowExecutionInfo)
         */
        default Builder executionInfo(Consumer<WorkflowExecutionInfo.Builder> executionInfo) {
            return executionInfo(WorkflowExecutionInfo.builder().applyMutation(executionInfo).build());
        }

        /**
         * <p>
         * The configuration settings for this workflow execution including timeout values, tasklist etc.
         * </p>
         * 
         * @param executionConfiguration
         *        The configuration settings for this workflow execution including timeout values, tasklist etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionConfiguration(WorkflowExecutionConfiguration executionConfiguration);

        /**
         * <p>
         * The configuration settings for this workflow execution including timeout values, tasklist etc.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecutionConfiguration.Builder} avoiding
         * the need to create one manually via {@link WorkflowExecutionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecutionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #executionConfiguration(WorkflowExecutionConfiguration)}.
         * 
         * @param executionConfiguration
         *        a consumer that will call methods on {@link WorkflowExecutionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionConfiguration(WorkflowExecutionConfiguration)
         */
        default Builder executionConfiguration(Consumer<WorkflowExecutionConfiguration.Builder> executionConfiguration) {
            return executionConfiguration(WorkflowExecutionConfiguration.builder().applyMutation(executionConfiguration).build());
        }

        /**
         * <p>
         * The number of tasks for this workflow execution. This includes open and closed tasks of all types.
         * </p>
         * 
         * @param openCounts
         *        The number of tasks for this workflow execution. This includes open and closed tasks of all types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openCounts(WorkflowExecutionOpenCounts openCounts);

        /**
         * <p>
         * The number of tasks for this workflow execution. This includes open and closed tasks of all types.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecutionOpenCounts.Builder} avoiding
         * the need to create one manually via {@link WorkflowExecutionOpenCounts#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecutionOpenCounts.Builder#build()} is called
         * immediately and its result is passed to {@link #openCounts(WorkflowExecutionOpenCounts)}.
         * 
         * @param openCounts
         *        a consumer that will call methods on {@link WorkflowExecutionOpenCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openCounts(WorkflowExecutionOpenCounts)
         */
        default Builder openCounts(Consumer<WorkflowExecutionOpenCounts.Builder> openCounts) {
            return openCounts(WorkflowExecutionOpenCounts.builder().applyMutation(openCounts).build());
        }

        /**
         * <p>
         * The time when the last activity task was scheduled for this workflow execution. You can use this information
         * to determine if the workflow has not made progress for an unusually long period of time and might require a
         * corrective action.
         * </p>
         * 
         * @param latestActivityTaskTimestamp
         *        The time when the last activity task was scheduled for this workflow execution. You can use this
         *        information to determine if the workflow has not made progress for an unusually long period of time
         *        and might require a corrective action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestActivityTaskTimestamp(Instant latestActivityTaskTimestamp);

        /**
         * <p>
         * The latest executionContext provided by the decider for this workflow execution. A decider can provide an
         * executionContext (a free-form string) when closing a decision task using <a>RespondDecisionTaskCompleted</a>.
         * </p>
         * 
         * @param latestExecutionContext
         *        The latest executionContext provided by the decider for this workflow execution. A decider can provide
         *        an executionContext (a free-form string) when closing a decision task using
         *        <a>RespondDecisionTaskCompleted</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestExecutionContext(String latestExecutionContext);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private WorkflowExecutionInfo executionInfo;

        private WorkflowExecutionConfiguration executionConfiguration;

        private WorkflowExecutionOpenCounts openCounts;

        private Instant latestActivityTaskTimestamp;

        private String latestExecutionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowExecutionResponse model) {
            super(model);
            executionInfo(model.executionInfo);
            executionConfiguration(model.executionConfiguration);
            openCounts(model.openCounts);
            latestActivityTaskTimestamp(model.latestActivityTaskTimestamp);
            latestExecutionContext(model.latestExecutionContext);
        }

        public final WorkflowExecutionInfo.Builder getExecutionInfo() {
            return executionInfo != null ? executionInfo.toBuilder() : null;
        }

        @Override
        public final Builder executionInfo(WorkflowExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public final void setExecutionInfo(WorkflowExecutionInfo.BuilderImpl executionInfo) {
            this.executionInfo = executionInfo != null ? executionInfo.build() : null;
        }

        public final WorkflowExecutionConfiguration.Builder getExecutionConfiguration() {
            return executionConfiguration != null ? executionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder executionConfiguration(WorkflowExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        public final void setExecutionConfiguration(WorkflowExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        public final WorkflowExecutionOpenCounts.Builder getOpenCounts() {
            return openCounts != null ? openCounts.toBuilder() : null;
        }

        @Override
        public final Builder openCounts(WorkflowExecutionOpenCounts openCounts) {
            this.openCounts = openCounts;
            return this;
        }

        public final void setOpenCounts(WorkflowExecutionOpenCounts.BuilderImpl openCounts) {
            this.openCounts = openCounts != null ? openCounts.build() : null;
        }

        public final Instant getLatestActivityTaskTimestamp() {
            return latestActivityTaskTimestamp;
        }

        @Override
        public final Builder latestActivityTaskTimestamp(Instant latestActivityTaskTimestamp) {
            this.latestActivityTaskTimestamp = latestActivityTaskTimestamp;
            return this;
        }

        public final void setLatestActivityTaskTimestamp(Instant latestActivityTaskTimestamp) {
            this.latestActivityTaskTimestamp = latestActivityTaskTimestamp;
        }

        public final String getLatestExecutionContext() {
            return latestExecutionContext;
        }

        @Override
        public final Builder latestExecutionContext(String latestExecutionContext) {
            this.latestExecutionContext = latestExecutionContext;
            return this;
        }

        public final void setLatestExecutionContext(String latestExecutionContext) {
            this.latestExecutionContext = latestExecutionContext;
        }

        @Override
        public DescribeWorkflowExecutionResponse build() {
            return new DescribeWorkflowExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
